/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.hud;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.Permissions;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.hud.CompassHUD;
import org.blockartistry.DynSurround.client.hud.GuiOverlay;
import org.blockartistry.DynSurround.client.hud.InspectionHUD;
import org.blockartistry.DynSurround.client.hud.LightLevelHUD;
import org.blockartistry.DynSurround.client.hud.PotionHUD;

@SideOnly(value=Side.CLIENT)
public final class GuiHUDHandler {
    private static GuiHUDHandler INSTANCE;
    private final List<GuiOverlay> overlays = new ArrayList<GuiOverlay>();

    private GuiHUDHandler() {
        this.register(new PotionHUD());
        this.register(new InspectionHUD());
        if (Permissions.instance().allowCompassAndClockHUD()) {
            this.register(new CompassHUD());
        }
        if (Permissions.instance().allowLightLevelHUD()) {
            this.register(new LightLevelHUD());
        }
    }

    public void register(GuiOverlay overlay) {
        this.overlays.add(overlay);
    }

    public static void register() {
        INSTANCE = new GuiHUDHandler();
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static void unregister() {
        if (INSTANCE != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCE);
            INSTANCE = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        for (int i = 0; i < this.overlays.size(); ++i) {
            this.overlays.get(i).doRender(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent.Post event) {
        for (int i = 0; i < this.overlays.size(); ++i) {
            this.overlays.get(i).doRender(event);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.END || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (event.player == null || event.player.field_70170_p == null) {
            return;
        }
        if (event.player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        int tickRef = EnvironStateHandler.EnvironState.getTickCounter();
        for (int i = 0; i < this.overlays.size(); ++i) {
            this.overlays.get(i).doTick(tickRef);
        }
    }
}

