/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.hud;

import com.google.common.collect.Ordering;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.hud.GuiOverlay;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.Localization;
import org.blockartistry.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class PotionHUD
extends GuiOverlay {
    private static final Color TEXT_POTION_NAME = Color.MC_WHITE;
    private static final Color TEXT_POTION_NAME_BAD = Color.MC_RED;
    private static final Color TEXT_POTION_NAME_AMBIENT = Color.MC_GOLD;
    private static final Color TEXT_POTION_DURATION = Color.MC_GREEN;
    private static final Color TEXT_POTION_DURATION_LOW = Color.MC_RED;
    private static final Color TEXT_POTION_DURATION_LOW_DARK = Color.MC_DARKRED;
    protected final ObjectArray<PotionInfo> potions = new ObjectArray();

    private boolean skipDisplay(@Nonnull PotionEffect effect) {
        Potion potion = effect.func_188419_a();
        return potion == null || !potion.shouldRenderHUD(effect) || !potion.shouldRenderInvText(effect);
    }

    @Override
    public void doTick(int tickRef) {
        this.potions.clear();
        if (!ModOptions.player.potionHUD.potionHudEnabled || ModOptions.player.potionHUD.potionHudNone) {
            return;
        }
        EntityPlayerSP player2 = Minecraft.func_71410_x().field_71439_g;
        if (player2 == null) {
            return;
        }
        Collection collection = player2.func_70651_bq();
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (PotionEffect effect : Ordering.natural().reverse().sortedCopy((Iterable)collection)) {
            if (this.skipDisplay(effect)) continue;
            this.potions.add(new PotionInfo(effect));
        }
    }

    @Override
    public void doRender(RenderGameOverlayEvent.Pre event) {
        if (ModOptions.player.potionHUD.potionHudNone && event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS) {
            event.setCanceled(true);
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.POTION_ICONS || this.potions.size() == 0) {
            return;
        }
        event.setCanceled(true);
        ScaledResolution resolution = event.getResolution();
        float GUITOP = ModOptions.player.potionHUD.potionHudTopOffset;
        float GUILEFT = ModOptions.player.potionHUD.potionHudAnchor == 0 ? (float)ModOptions.player.potionHUD.potionHudLeftOffset : (float)(resolution.func_78326_a() - ModOptions.player.potionHUD.potionHudLeftOffset) - 120.0f * ModOptions.player.potionHUD.potionHudScale;
        float SCALE = ModOptions.player.potionHUD.potionHudScale;
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = mc.field_71466_p;
        int guiLeft = 2;
        int guiTop = 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)GUILEFT, (float)GUITOP, (float)0.0f);
        GlStateManager.func_179152_a((float)SCALE, (float)SCALE, (float)SCALE);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        int k = 33;
        if (this.potions.size() > 7) {
            k = 198 / (this.potions.size() - 1);
        }
        for (PotionInfo potion : this.potions) {
            mc.func_110434_K().func_110577_a(GuiContainer.field_147001_a);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)ModOptions.player.potionHUD.potionHudTransparency);
            this.func_73729_b(2, guiTop, 0, 166, 140, 32);
            if (potion.hasStatusIcon()) {
                int l = potion.getStatusIconIndex();
                this.func_73729_b(8, guiTop + 7, 0 + l % 8 * 18, 198 + l / 8 * 18, 18, 18);
            }
            try {
                potion.getPotion().renderInventoryEffect(2, guiTop, potion.getPotionEffect(), mc);
            }
            catch (Exception l) {
                // empty catch block
            }
            String potionText = potion.getEffectText();
            String durationText = potion.getDurationText();
            if (potionText != null) {
                font.func_175063_a(potionText, 30.0f, (float)(guiTop + 6), potion.getEffectColor());
                font.func_175063_a(durationText, 30.0f, (float)(guiTop + 6 + 10), potion.getDurationColor());
            }
            guiTop += k;
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static class PotionInfo {
        private final PotionEffect potionEffect;
        private final Potion potion;
        private final int effectColor;
        private final String effectText;
        private final int durationColor;
        private final String durationText;

        public PotionInfo(@Nonnull PotionEffect potion) {
            this.potionEffect = potion;
            this.potion = this.potionEffect.func_188419_a();
            if (this.potion.shouldRenderInvText(this.potionEffect)) {
                String s1 = Localization.format(this.potion.func_76393_a(), new Object[0]);
                if (this.potionEffect.func_76458_c() == 1) {
                    s1 = s1 + " " + Localization.format("enchantment.level.2", new Object[0]);
                } else if (this.potionEffect.func_76458_c() == 2) {
                    s1 = s1 + " " + Localization.format("enchantment.level.3", new Object[0]);
                } else if (this.potionEffect.func_76458_c() == 3) {
                    s1 = s1 + " " + Localization.format("enchantment.level.4", new Object[0]);
                }
                this.effectText = s1;
                this.effectColor = (this.potion.func_76398_f() ? TEXT_POTION_NAME_BAD : (this.potionEffect.func_82720_e() ? TEXT_POTION_NAME_AMBIENT : TEXT_POTION_NAME)).rgbWithAlpha(ModOptions.player.potionHUD.potionHudTransparency);
                int threshold = this.potionEffect.func_82720_e() ? 170 : 200;
                int duration = this.potionEffect.func_76459_b();
                this.durationColor = (duration <= threshold ? ((duration / 10 & 1) != 0 ? TEXT_POTION_DURATION_LOW_DARK : TEXT_POTION_DURATION_LOW) : TEXT_POTION_DURATION).rgbWithAlpha(ModOptions.player.potionHUD.potionHudTransparency);
                this.durationText = Potion.func_188410_a((PotionEffect)this.potionEffect, (float)1.0f);
            } else {
                this.effectText = null;
                this.durationText = null;
                this.durationColor = -1;
                this.effectColor = -1;
            }
        }

        public PotionEffect getPotionEffect() {
            return this.potionEffect;
        }

        public Potion getPotion() {
            return this.potion;
        }

        public boolean hasStatusIcon() {
            return this.potion.func_76400_d();
        }

        public int getStatusIconIndex() {
            return this.potion.func_76392_e();
        }

        public String getEffectText() {
            return this.effectText;
        }

        public int getEffectColor() {
            return this.effectColor;
        }

        public String getDurationText() {
            return this.durationText;
        }

        public int getDurationColor() {
            return this.durationColor;
        }
    }
}

