/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.sound;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.handlers.SoundEffectHandler;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.client.sound.SoundEngine;
import org.blockartistry.DynSurround.registry.SoundMetadata;
import org.blockartistry.lib.gui.RecordTitleEmitter;
import org.blockartistry.lib.random.XorShiftRandom;
import org.blockartistry.lib.sound.BasicSound;

@SideOnly(value=Side.CLIENT)
public abstract class Emitter {
    protected final Random RANDOM = XorShiftRandom.current();
    protected final SoundEffect effect;
    @Nullable
    protected final RecordTitleEmitter titleEmitter;
    protected BasicSound<?> activeSound;
    protected boolean done = false;

    public Emitter(@Nonnull SoundEffect sound2) {
        this.effect = sound2;
        RecordTitleEmitter.ITimeKeeper timer = new RecordTitleEmitter.ITimeKeeper(){

            @Override
            public int getTickMark() {
                return EnvironStateHandler.EnvironState.getTickCounter();
            }
        };
        if (StringUtils.isEmpty((CharSequence)sound2.getSoundTitle())) {
            SoundMetadata data = ClientRegistry.SOUND.getSoundMetadata(this.effect.getSound().getRegistryName());
            if (data != null) {
                if (!StringUtils.isEmpty((CharSequence)data.getTitle())) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(data.getTitle());
                    if (data.getCredits().size() > 0) {
                        builder.append(" by ").append(data.getCredits().get(0));
                    }
                    this.titleEmitter = new RecordTitleEmitter(builder.toString(), timer);
                } else {
                    this.titleEmitter = null;
                }
            } else {
                this.titleEmitter = null;
            }
        } else {
            this.titleEmitter = new RecordTitleEmitter(sound2.getSoundTitle(), timer);
        }
    }

    protected abstract BasicSound<?> createSound();

    public void update() {
        if (this.titleEmitter != null) {
            this.titleEmitter.func_73660_a();
        }
        if (this.activeSound == null) {
            this.activeSound = this.createSound();
        } else {
            if (this.activeSound.getState().isActive()) {
                return;
            }
            if (this.isFading()) {
                this.done = true;
                return;
            }
        }
        try {
            if (this.activeSound.canSoundBeHeard(EnvironStateHandler.EnvironState.getPlayerPosition())) {
                SoundEffectHandler.INSTANCE.playSound(this.activeSound);
            }
        }
        catch (Throwable t) {
            DSurround.log().error("Unable to play sound", t);
        }
    }

    public void setVolume(float volume) {
        if (this.activeSound != null) {
            this.activeSound.setVolume(volume);
        }
    }

    public float getVolume() {
        return this.activeSound != null ? this.activeSound.func_147653_e() : 0.0f;
    }

    public void setVolumeThrottle(float throttle) {
        if (this.activeSound != null) {
            this.activeSound.setVolumeThrottle(throttle);
        }
    }

    public void setPitch(float pitch) {
        if (this.activeSound != null) {
            this.activeSound.setPitch(pitch);
        }
    }

    public float getPitch() {
        return this.activeSound != null ? this.activeSound.func_147655_f() : 0.0f;
    }

    public void fade() {
        if (this.activeSound != null) {
            DSurround.log().debug("FADE: %s", this.activeSound.toString());
            this.activeSound.fade();
        }
    }

    public boolean isFading() {
        if (this.activeSound != null) {
            return this.activeSound.isFading();
        }
        return false;
    }

    public void unfade() {
        if (this.activeSound != null) {
            DSurround.log().debug("UNFADE: %s", this.activeSound.toString());
            this.activeSound.unfade();
        }
    }

    public boolean isDonePlaying() {
        if (this.activeSound != null) {
            return this.done || this.activeSound.isDonePlaying();
        }
        return this.done;
    }

    public void stop() {
        if (this.activeSound != null) {
            this.activeSound.setRepeat(false);
            SoundEngine.instance().stopSound(this.activeSound);
        }
    }

    public String toString() {
        return this.activeSound.toString();
    }
}

