/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.sound;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.sound.SoundManagerReplacement;
import org.blockartistry.lib.sound.BasicSound;

@SideOnly(value=Side.CLIENT)
public class SoundEngine {
    private static SoundEngine instance = null;

    public static SoundEngine instance() {
        if (instance == null) {
            instance = new SoundEngine();
        }
        return instance;
    }

    private SoundEngine() {
    }

    private static SoundManagerReplacement getManager() {
        return SoundManagerReplacement.getSoundManager();
    }

    public int currentSoundCount() {
        return SoundEngine.getManager().currentSoundCount();
    }

    public int maxSoundCount() {
        return SoundEngine.getManager().maxSoundCount();
    }

    public boolean isSoundPlaying(@Nonnull BasicSound<?> sound2) {
        return SoundEngine.getManager().func_148597_a((ISound)sound2);
    }

    public boolean isSoundPlaying(@Nonnull String soundId) {
        return SoundEngine.getManager().isSoundPlaying(soundId);
    }

    public void stopSound(@Nonnull String sound2) {
        this.stopSound(sound2, null);
    }

    public void stopSound(@Nonnull String sound2, @Nonnull SoundCategory cat) {
        SoundEngine.getManager().func_189567_a(sound2, cat);
    }

    public void stopSound(@Nonnull BasicSound<?> sound2) {
        SoundEngine.getManager().func_148602_b((ISound)sound2);
    }

    public void stopAllSounds() {
        SoundEngine.getManager().func_148614_c();
    }

    @Nullable
    public String playSound(@Nonnull BasicSound<?> sound2) {
        SoundEngine.getManager().func_148611_c((ISound)sound2);
        return sound2.getId();
    }
}

