/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.sound;

import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.sound.SoundState;
import org.blockartistry.DynSurround.event.DiagnosticEvent;
import org.blockartistry.lib.compat.ModEnvironment;
import org.blockartistry.lib.math.MathStuff;
import org.blockartistry.lib.sound.BasicSound;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
public class SoundManagerReplacement
extends SoundManager {
    private static Field soundPhysicsGlobalVolume;
    private static final int SOUND_QUEUE_SLACK = 6;
    private static final int MAX_STREAM_CHANNELS = 16;
    private static final float MUTE_VOLUME = 1.0E-5f;
    private final Object mutex = new Object();
    private int violationCount = 0;

    public static SoundManagerReplacement getSoundManager() {
        return (SoundManagerReplacement)Minecraft.func_71410_x().func_147118_V().field_147694_f;
    }

    public SoundManagerReplacement(SoundHandler handler, GameSettings settings) {
        super(handler, settings);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (soundPhysicsGlobalVolume != null) {
            DSurround.log().info("SoundPhysics present and using global volume multiplier", new Object[0]);
        }
    }

    private void checkForClientThread(String method) {
        this.checkForClientThread(method, null);
    }

    private void checkForClientThread(String method, ISound sound2) {
        String name;
        if (ModOptions.logging.enableDebugLogging && !(name = Thread.currentThread().getName()).equals("Client thread")) {
            ResourceLocation rl;
            ++this.violationCount;
            DSurround.log().warn("SoundManager.%s() access by non-client thread [%s]!", method, name);
            if (sound2 != null && (rl = sound2.func_147650_b()) != null) {
                DSurround.log().warn("The sound in question is: %s", rl.toString());
            }
        }
    }

    private SoundSystem getSoundSystem() {
        return this.field_148620_e;
    }

    private void setState(@Nonnull ISound sound2, @Nonnull SoundState state) {
        if (sound2 instanceof BasicSound) {
            ((BasicSound)sound2).setState(state);
        }
    }

    private void setStateIf(@Nonnull ISound sound2, @Nonnull SoundState current, @Nonnull SoundState state) {
        BasicSound s;
        if (sound2 instanceof BasicSound && (s = (BasicSound)sound2).getState() == current) {
            s.setState(state);
        }
    }

    private void stopSound(@Nonnull BasicSound<?> sound2) {
        if (!StringUtils.isEmpty((CharSequence)sound2.getId()) && this.getSoundSystem() != null) {
            this.getSoundSystem().stop(sound2.getId());
        }
        super.func_148602_b(sound2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_148602_b(@Nonnull ISound sound2) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("stopSound", sound2);
            try {
                if (sound2 instanceof BasicSound) {
                    this.stopSound((BasicSound)sound2);
                } else {
                    super.func_148602_b(sound2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSound(@Nonnull String soundId, @Nullable SoundCategory cat) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("stopSound");
            if (cat != null) {
                super.func_189567_a(soundId, cat);
            } else {
                ISound s = (ISound)this.field_148629_h.get(soundId);
                if (s != null) {
                    this.func_148602_b(s);
                }
            }
        }
    }

    private boolean isSoundPlaying(@Nonnull BasicSound<?> sound2) {
        return super.func_148597_a(sound2) || this.field_148630_i.containsKey(sound2) || this.field_148626_m.containsKey(sound2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_148597_a(@Nonnull ISound sound2) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("isSoundPlaying", sound2);
            try {
                if (sound2 instanceof BasicSound) {
                    return this.isSoundPlaying((BasicSound)sound2);
                }
                return super.func_148597_a(sound2);
            }
            catch (Throwable throwable) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSoundPlaying(@Nonnull String soundId) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("isSoundPlaying");
            if (StringUtils.isEmpty((CharSequence)soundId)) {
                return false;
            }
            return this.field_148629_h.containsKey(soundId);
        }
    }

    private boolean canFitSound() {
        return this.currentSoundCount() < this.numberOfNormalChannels() - 6;
    }

    private void playSound(@Nonnull BasicSound<?> sound2) {
        if (!this.canFitSound() && ModOptions.logging.enableDebugLogging) {
            DSurround.log().debug("> NO ROOM: [%s]", sound2.toString());
        }
        if (!StringUtils.isEmpty((CharSequence)sound2.getId())) {
            this.stopSound(sound2);
        }
        sound2.setId("");
        if (!ModEnvironment.ActualMusic.isLoaded() || sound2.func_184365_d() != SoundCategory.MUSIC) {
            super.func_148611_c(sound2);
        }
        if (StringUtils.isEmpty((CharSequence)sound2.getId())) {
            sound2.setState(SoundState.ERROR);
        } else {
            sound2.setState(SoundState.PLAYING);
        }
        if (ModOptions.logging.enableDebugLogging) {
            if (StringUtils.isEmpty((CharSequence)sound2.getId())) {
                DSurround.log().debug("> NOT QUEUED: [%s]", sound2.toString());
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("> QUEUED: [").append(sound2.toString()).append(']');
                if (DSurround.log().testTrace(1)) {
                    SoundSystem ss = this.getSoundSystem();
                    ss.CommandQueue(null);
                    float v = ss.getVolume(sound2.getId());
                    float p = ss.getPitch(sound2.getId());
                    builder.append("; v: ").append(v).append(", p: ").append(p);
                }
                DSurround.log().debug(builder.toString(), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_148611_c(@Nonnull ISound sound2) {
        if (sound2 != null) {
            try {
                Object object = this.mutex;
                synchronized (object) {
                    this.checkForClientThread("playSound", sound2);
                    if (sound2 instanceof BasicSound) {
                        this.playSound((BasicSound)sound2);
                    } else if (!ModEnvironment.ActualMusic.isLoaded() || sound2.func_184365_d() != SoundCategory.MUSIC) {
                        if (DSurround.log().testTrace(2)) {
                            DSurround.log().debug("Playing vanilla sound [%s]", sound2.func_147650_b().toString());
                        }
                        super.func_148611_c(sound2);
                    }
                }
                this.getSoundSystem().CommandQueue(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void playDelayedSound(@Nonnull BasicSound<?> sound2, int delay) {
        sound2.setId("");
        super.func_148599_a(sound2, delay);
        sound2.setState(SoundState.DELAYED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_148599_a(@Nonnull ISound sound2, int delay) {
        if (sound2 != null) {
            try {
                Object object = this.mutex;
                synchronized (object) {
                    this.checkForClientThread("playDelayedSound", sound2);
                    if (sound2 instanceof BasicSound) {
                        this.playDelayedSound((BasicSound)sound2, delay);
                    } else {
                        super.func_148599_a(sound2, delay);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_148614_c() {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("stopAllSounds");
            if (this.field_148617_f) {
                for (ISound s : this.field_148629_h.values()) {
                    this.setState(s, SoundState.DONE);
                }
                for (ISound s : this.field_148626_m.keySet()) {
                    this.setState(s, SoundState.DONE);
                }
            }
            super.func_148614_c();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_148610_e() {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("pauseAllSounds");
            for (ISound s : this.field_148629_h.values()) {
                this.setStateIf(s, SoundState.PLAYING, SoundState.PAUSED);
            }
            super.func_148610_e();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_148604_f() {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("resumeAllSounds");
            for (ISound s : this.field_148629_h.values()) {
                this.setStateIf(s, SoundState.PAUSED, SoundState.PLAYING);
            }
            super.func_148604_f();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_148605_d() {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("updateAllSounds");
            SoundSystem sndSystem = this.getSoundSystem();
            ++this.field_148618_g;
            for (ITickableSound itickablesound : this.field_148625_l) {
                itickablesound.func_73660_a();
                if (itickablesound.func_147667_k()) {
                    this.func_148602_b((ISound)itickablesound);
                    continue;
                }
                String s = (String)this.field_148630_i.get(itickablesound);
                Object object2 = SoundSystemConfig.THREAD_SYNC;
                synchronized (object2) {
                    sndSystem.setVolume(s, this.func_188770_e((ISound)itickablesound));
                    sndSystem.setPitch(s, this.func_188772_d((ISound)itickablesound));
                    sndSystem.setPosition(s, itickablesound.func_147649_g(), itickablesound.func_147654_h(), itickablesound.func_147651_i());
                }
            }
            Iterator iterator = this.field_148629_h.entrySet().iterator();
            while (iterator.hasNext()) {
                int minThresholdDelay;
                Map.Entry entry = iterator.next();
                String s1 = (String)entry.getKey();
                if (sndSystem.playing(s1)) continue;
                ISound isound = (ISound)entry.getValue();
                int j = isound.func_147652_d();
                int n = minThresholdDelay = isound instanceof BasicSound ? 0 : 1;
                if (isound.func_147657_c() && j >= minThresholdDelay) {
                    this.func_148599_a(isound, j);
                } else {
                    this.setState(isound, SoundState.DONE);
                }
                iterator.remove();
                sndSystem.removeSource(s1);
                this.field_148624_n.remove(s1);
                try {
                    this.field_188776_k.remove((Object)isound.func_184365_d(), (Object)s1);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (!(isound instanceof ITickableSound)) continue;
                this.field_148625_l.remove(isound);
            }
            Iterator iterator1 = this.field_148626_m.entrySet().iterator();
            while (iterator1.hasNext()) {
                Map.Entry entry1 = iterator1.next();
                if (this.field_148618_g < (Integer)entry1.getValue()) continue;
                ISound isound1 = (ISound)entry1.getKey();
                if (isound1 instanceof ITickableSound) {
                    ((ITickableSound)isound1).func_73660_a();
                }
                this.func_148611_c(isound1);
                iterator1.remove();
            }
        }
    }

    @SubscribeEvent
    public void onSoundSourceEvent(@Nonnull SoundEvent.SoundSourceEvent event) {
        ISound sound2 = event.getSound();
        if (sound2 instanceof BasicSound) {
            ((BasicSound)sound2).setId(event.getUuid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent(priority=EventPriority.LOW)
    public void diagnostics(DiagnosticEvent.Gather event) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("diagnostics");
            if (this.violationCount > 0) {
                event.output.add(String.format(TextFormatting.RED + "SoundManager violations: %d", this.violationCount));
            }
            TObjectIntHashMap counts = new TObjectIntHashMap();
            for (Map.Entry entry : this.field_148629_h.entrySet()) {
                ISound isound = (ISound)entry.getValue();
                counts.adjustOrPutValue((Object)isound.func_184364_b().func_188719_a().toString(), 1, 1);
            }
            ArrayList<String> results = new ArrayList<String>();
            TObjectIntIterator itr = counts.iterator();
            while (itr.hasNext()) {
                itr.advance();
                results.add(String.format(TextFormatting.GOLD + "%s: %d", itr.key(), itr.value()));
            }
            Collections.sort(results);
            event.output.addAll(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int currentSoundCount() {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("currentSoundCount");
            return this.field_148624_n.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int maxSoundCount() {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("maxSoundCount");
            return SoundSystemConfig.getNumberNormalChannels() + SoundSystemConfig.getNumberStreamingChannels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfNormalChannels() {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("numberOfNormalChannels");
            return SoundSystemConfig.getNumberNormalChannels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMuted() {
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("isMuted");
            return this.field_148620_e != null && this.getSoundSystem().getMasterVolume() == 1.0E-5f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMuted(boolean flag) {
        if (!this.field_148617_f || this.field_148620_e == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.checkForClientThread("setMuted");
            SoundSystem ss = this.getSoundSystem();
            try {
                if (flag) {
                    ss.setMasterVolume(1.0E-5f);
                } else {
                    GameSettings options = Minecraft.func_71410_x().field_71474_y;
                    ss.setMasterVolume(options.func_186711_a(SoundCategory.MASTER));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public float func_188770_e(@Nonnull ISound sound2) {
        float volumeScale = ClientRegistry.SOUND.getVolumeScale(sound2);
        float volume = sound2.func_147653_e() * this.func_188769_a(sound2.func_184365_d()) * volumeScale;
        float result = MathStuff.clamp(volume, 0.0f, 1.0f);
        try {
            if (soundPhysicsGlobalVolume != null) {
                return result * soundPhysicsGlobalVolume.getFloat(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static void alErrorCheck() {
        int error = AL10.alGetError();
        if (error != 0) {
            DSurround.log().warn("OpenAL error: %d", error);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void configureSound(@Nonnull SoundSetupEvent event) {
        int totalChannels = -1;
        try {
            boolean create;
            boolean bl = create = !AL.isCreated();
            if (create) {
                AL.create();
                SoundManagerReplacement.alErrorCheck();
            }
            IntBuffer ib = BufferUtils.createIntBuffer((int)1);
            ALC10.alcGetInteger((ALCdevice)AL.getDevice(), (int)4112, (IntBuffer)ib);
            SoundManagerReplacement.alErrorCheck();
            totalChannels = ib.get(0);
            if (create) {
                AL.destroy();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        int normalChannelCount = ModOptions.sound.normalSoundChannelCount;
        int streamChannelCount = ModOptions.sound.streamingSoundChannelCount;
        if (ModOptions.sound.autoConfigureChannels && totalChannels > 64) {
            totalChannels = (totalChannels + 1) * 3 / 4;
            streamChannelCount = Math.min(totalChannels / 5, 16);
            normalChannelCount = totalChannels - streamChannelCount;
        }
        DSurround.log().info("Sound channels: %d normal, %d streaming (total avail: %s)", normalChannelCount, streamChannelCount, totalChannels == -1 ? "UNKNOWN" : Integer.toString(totalChannels));
        SoundSystemConfig.setNumberNormalChannels((int)normalChannelCount);
        SoundSystemConfig.setNumberStreamingChannels((int)streamChannelCount);
        if (ModOptions.sound.streamBufferCount != 0) {
            SoundSystemConfig.setNumberStreamingBuffers((int)ModOptions.sound.streamBufferCount);
        }
        if (ModOptions.sound.streamBufferSize != 0) {
            SoundSystemConfig.setStreamingBufferSize((int)(ModOptions.sound.streamBufferSize * 1024));
        }
        DSurround.log().info("Stream buffers: %d x %d", SoundSystemConfig.getNumberStreamingBuffers(), SoundSystemConfig.getStreamingBufferSize());
    }

    static {
        try {
            Class<?> soundPhysics = Class.forName("com.sonicether.soundphysics.SoundPhysics");
            soundPhysicsGlobalVolume = ReflectionHelper.findField(soundPhysics, (String[])new String[]{"globalVolumeMultiplier"});
        }
        catch (Exception ex) {
            soundPhysicsGlobalVolume = null;
        }
    }
}

