/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.sound;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.registry.SoundMetadata;
import org.blockartistry.lib.sound.SoundConfigProcessor;

@Mod.EventBusSubscriber
public final class Sounds {
    public static SoundEffect CRAFTING;
    public static SoundEffect SWORD_EQUIP;
    public static SoundEffect SWORD_SWING;
    public static SoundEffect AXE_EQUIP;
    public static SoundEffect AXE_SWING;
    public static SoundEffect BOW_EQUIP;
    public static SoundEffect BOW_PULL;
    public static SoundEffect TOOL_EQUIP;
    public static SoundEffect TOOL_SWING;
    public static SoundEffect UTILITY_EQUIP;
    public static SoundEffect FOOD_EQUIP;
    public static SoundEffect SHIELD_EQUIP;
    public static SoundEffect SHIELD_USE;
    public static SoundEffect LIGHT_ARMOR_EQUIP;
    public static SoundEffect MEDIUM_ARMOR_EQUIP;
    public static SoundEffect HEAVY_ARMOR_EQUIP;
    public static SoundEffect CRYSTAL_ARMOR_EQUIP;
    public static SoundEffect THUNDER;
    public static SoundEffect RAINFALL;
    public static SoundEffect WATER_DROP;
    public static SoundEffect WATER_DRIP;
    public static SoundEffect STEAM_HISS;
    public static SoundEffect FIRE;
    public static SoundEffect WATERFALL0;
    public static SoundEffect WATERFALL1;
    public static SoundEffect WATERFALL2;
    public static SoundEffect WATERFALL3;
    public static SoundEffect WATERFALL4;
    public static SoundEffect WATERFALL5;
    public static SoundEvent RAIN;
    public static SoundEvent DUST;
    public static SoundEvent SILENCE;
    public static SoundEffect AMBIENT_CAVE;
    private static final Map<ResourceLocation, SoundMetadata> soundMetadata;
    private static final Map<ResourceLocation, SoundEvent> myRegistry;

    private Sounds() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerSounds(@Nonnull RegistryEvent.Register<SoundEvent> event) {
        DSurround.log().info("Registering sounds", new Object[0]);
        ResourceLocation soundFile = new ResourceLocation("dsurround", "sounds.json");
        IForgeRegistry registry = event.getRegistry();
        try (SoundConfigProcessor proc = new SoundConfigProcessor(soundFile);){
            proc.forEach((sound2, meta) -> {
                SoundMetadata data = new SoundMetadata(meta);
                ResourceLocation resource = new ResourceLocation("dsurround", sound2);
                SoundEvent se = (SoundEvent)new SoundEvent(resource).setRegistryName(resource);
                registry.register((IForgeRegistryEntry)se);
                soundMetadata.put(resource, data);
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (SoundEvent se : SoundEvent.field_187505_a) {
            myRegistry.put(se.getRegistryName(), se);
        }
        for (SoundEvent se : registry) {
            myRegistry.put(se.getRegistryName(), se);
        }
        SILENCE = Sounds.getSound(new ResourceLocation("dsurround", "silence"));
        RAIN = Sounds.getSound(new ResourceLocation("dsurround", "rain"));
        DUST = Sounds.getSound(new ResourceLocation("dsurround", "dust"));
        CRAFTING = new SoundEffect.Builder("crafting", SoundCategory.PLAYERS).build();
        SWORD_EQUIP = new SoundEffect.Builder("sword.equip", SoundCategory.PLAYERS).setVolume(0.5f).build();
        SWORD_SWING = new SoundEffect.Builder("sword.swing", SoundCategory.PLAYERS).build();
        AXE_EQUIP = new SoundEffect.Builder("blunt.equip", SoundCategory.PLAYERS).setVolume(0.35f).build();
        AXE_SWING = new SoundEffect.Builder("blunt.swing", SoundCategory.PLAYERS).build();
        BOW_EQUIP = new SoundEffect.Builder("bow.equip", SoundCategory.PLAYERS).setVolume(0.3f).build();
        BOW_PULL = new SoundEffect.Builder("bow.pull", SoundCategory.PLAYERS).build();
        TOOL_EQUIP = new SoundEffect.Builder("tool.equip", SoundCategory.PLAYERS).setVolume(0.3f).build();
        TOOL_SWING = new SoundEffect.Builder("tool.swing", SoundCategory.PLAYERS).build();
        UTILITY_EQUIP = new SoundEffect.Builder("utility.equip", SoundCategory.PLAYERS).setVolume(0.35f).build();
        FOOD_EQUIP = new SoundEffect.Builder("food.equip", SoundCategory.PLAYERS).setVolume(0.35f).build();
        SHIELD_EQUIP = new SoundEffect.Builder("shield.equip", SoundCategory.PLAYERS).setVolume(0.3f).build();
        SHIELD_USE = new SoundEffect.Builder("shield.use", SoundCategory.PLAYERS).setVolume(0.3f).build();
        LIGHT_ARMOR_EQUIP = new SoundEffect.Builder("fs.armor.light_walk", SoundCategory.PLAYERS).build();
        MEDIUM_ARMOR_EQUIP = new SoundEffect.Builder("fs.armor.medium_walk", SoundCategory.PLAYERS).build();
        HEAVY_ARMOR_EQUIP = new SoundEffect.Builder("fs.armor.heavy_walk", SoundCategory.PLAYERS).build();
        CRYSTAL_ARMOR_EQUIP = new SoundEffect.Builder("fs.armor.crystal_walk", SoundCategory.PLAYERS).build();
        THUNDER = new SoundEffect.Builder("thunder", SoundCategory.WEATHER).setVolume(10000.0f).build();
        RAINFALL = new SoundEffect.Builder("rain", SoundCategory.WEATHER).build();
        WATER_DROP = new SoundEffect.Builder("waterdrops", SoundCategory.AMBIENT).build();
        WATER_DRIP = new SoundEffect.Builder("waterdrips", SoundCategory.AMBIENT).build();
        STEAM_HISS = new SoundEffect.Builder(new ResourceLocation("block.fire.extinguish"), SoundCategory.AMBIENT).setVolume(0.1f).setPitch(1.0f).build();
        FIRE = new SoundEffect.Builder(new ResourceLocation("minecraft:block.fire.ambient"), SoundCategory.BLOCKS).build();
        WATERFALL0 = new SoundEffect.Builder("waterfall.0", SoundCategory.AMBIENT).build();
        WATERFALL1 = new SoundEffect.Builder("waterfall.1", SoundCategory.AMBIENT).build();
        WATERFALL2 = new SoundEffect.Builder("waterfall.2", SoundCategory.AMBIENT).build();
        WATERFALL3 = new SoundEffect.Builder("waterfall.3", SoundCategory.AMBIENT).build();
        WATERFALL4 = new SoundEffect.Builder("waterfall.4", SoundCategory.AMBIENT).build();
        WATERFALL5 = new SoundEffect.Builder("waterfall.5", SoundCategory.AMBIENT).build();
        AMBIENT_CAVE = new SoundEffect.Builder(new ResourceLocation("minecraft:ambient.cave"), SoundCategory.AMBIENT).build();
    }

    @Nullable
    public static SoundMetadata getSoundMetadata(@Nonnull ResourceLocation resource) {
        return soundMetadata.get(resource);
    }

    public static SoundEvent getSound(ResourceLocation sound2) {
        SoundEvent evt = myRegistry.get(sound2);
        if (evt == null) {
            DSurround.log().warn("Cannot find sound that should be registered [%s]", sound2.toString());
            return SILENCE;
        }
        return evt;
    }

    static {
        soundMetadata = Maps.newHashMap();
        myRegistry = Maps.newHashMap();
    }
}

