/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.sound;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.lib.sound.BasicSound;

@SideOnly(value=Side.CLIENT)
public class SpotSound
extends BasicSound<SpotSound> {
    private static final int SPOT_SOUND_RANGE = 8;
    public static final BasicSound.ISoundScale BIOME_EFFECT = () -> ModOptions.sound.masterSoundScaleFactor;

    public SpotSound() {
        super((ResourceLocation)null, SoundCategory.PLAYERS);
        this.setVolumeScale(BIOME_EFFECT);
    }

    SpotSound(@Nonnull BlockPos pos, @Nonnull SoundEffect sound2) {
        super(sound2.getSound(), sound2.getCategory());
        this.field_147662_b = sound2.getVolume();
        this.field_147663_c = sound2.getPitch(this.RANDOM);
        this.field_147659_g = false;
        this.field_147665_h = 0;
        this.setPosition((Vec3i)pos);
        this.setVolumeScale(BIOME_EFFECT);
    }

    private float randomRange(int range) {
        return this.RANDOM.nextInt(range) - this.RANDOM.nextInt(range);
    }

    SpotSound(@Nonnull Entity player2, @Nonnull SoundEffect sound2) {
        super(sound2.getSound(), sound2.getCategory());
        this.field_147662_b = sound2.getVolume();
        this.field_147663_c = sound2.getPitch(this.RANDOM);
        this.field_147659_g = false;
        this.field_147665_h = 0;
        this.setPosition(player2);
        if (sound2.getCategory() != SoundCategory.PLAYERS) {
            this.field_147660_d += this.randomRange(8);
            this.field_147661_e += this.randomRange(8);
            this.field_147658_f += this.randomRange(8);
        }
        this.setVolumeScale(BIOME_EFFECT);
    }
}

