/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.sound;

import javax.annotation.Nonnull;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.client.sound.SpotSound;
import org.blockartistry.lib.sound.BasicSound;

@SideOnly(value=Side.CLIENT)
public class TrackingSound
extends BasicSound<TrackingSound>
implements ITickableSound {
    private static final float DONE_VOLUME_THRESHOLD = 1.0E-5f;
    private static final float FADE_AMOUNT = 0.02f;
    private final Entity attachedTo;
    private final SoundEffect sound;
    private boolean isFading;
    private float maxVolume;
    private boolean isDonePlaying;
    private long lastTick;

    TrackingSound(@Nonnull Entity attachedTo, @Nonnull SoundEffect sound2, boolean fadeIn) {
        super(sound2.getSound(), sound2.getCategory());
        this.attachedTo = attachedTo;
        this.field_147659_g = sound2.isRepeatable();
        this.sound = sound2;
        this.maxVolume = sound2.getVolume();
        this.field_147662_b = fadeIn ? 2.0E-5f : this.maxVolume;
        this.field_147663_c = sound2.getPitch(this.RANDOM);
        this.lastTick = EnvironStateHandler.EnvironState.getTickCounter() - 1;
        this.updateLocation();
        this.setVolumeScale(SpotSound.BIOME_EFFECT);
    }

    public boolean func_147657_c() {
        return !this.func_147667_k() && super.func_147657_c();
    }

    public int func_147652_d() {
        return this.sound.getRepeat(this.RANDOM);
    }

    @Override
    public void fade() {
        this.isFading = true;
    }

    @Override
    public void unfade() {
        this.isFading = false;
    }

    @Override
    public boolean isFading() {
        return this.isFading;
    }

    public boolean func_147667_k() {
        return this.isDonePlaying;
    }

    public boolean sameSound(SoundEffect snd) {
        return this.sound.equals(snd);
    }

    public void updateLocation() {
        AxisAlignedBB box = this.attachedTo.func_174813_aQ();
        this.setPosition(box.func_189972_c());
    }

    public boolean isEntityAlive() {
        return this.attachedTo.func_70089_S();
    }

    public void func_73660_a() {
        if (this.func_147667_k()) {
            return;
        }
        if (!this.isEntityAlive()) {
            this.isDonePlaying = true;
            return;
        }
        long tickDelta = (long)EnvironStateHandler.EnvironState.getTickCounter() - this.lastTick;
        if (tickDelta == 0L) {
            return;
        }
        this.lastTick = EnvironStateHandler.EnvironState.getTickCounter();
        if (this.isFading()) {
            this.field_147662_b -= 0.02f * (float)tickDelta;
        } else if (this.field_147662_b < this.maxVolume) {
            this.field_147662_b += 0.02f * (float)tickDelta;
        }
        if (this.field_147662_b > this.maxVolume) {
            this.field_147662_b = this.maxVolume;
        }
        if (this.field_147662_b <= 1.0E-5f) {
            this.isDonePlaying = true;
            this.field_147662_b = 0.0f;
        } else {
            this.updateLocation();
        }
    }

    @Override
    public TrackingSound setVolume(float volume) {
        if (volume < this.maxVolume || !this.isFading) {
            this.maxVolume = volume;
        }
        return this;
    }
}

