/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.swing;

import java.awt.BorderLayout;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.swing.BlockViewer;
import org.blockartistry.DynSurround.client.swing.DataProxy;
import org.blockartistry.DynSurround.client.swing.ScriptVariables;
import org.blockartistry.DynSurround.client.swing.WeatherStatus;

@SideOnly(value=Side.CLIENT)
public class DiagnosticPanel
extends JPanel {
    static final Font SERVER_GUI_FONT = new Font("Monospaced", 0, 12);
    protected final JFrame frame;
    protected final JTabbedPane tabs;
    private static DiagnosticPanel INSTANCE = null;

    protected DiagnosticPanel() {
        this.setLayout(new BorderLayout());
        this.frame = new JFrame("Dynamic Surroundings Diagnostics");
        this.frame.setDefaultCloseOperation(0);
        this.tabs = new JTabbedPane();
        this.add(this.tabs);
        this.tabs.add(new ScriptVariables());
        this.tabs.add(new WeatherStatus());
        this.tabs.add(new BlockViewer());
        this.frame.getContentPane().add(this);
        this.frame.pack();
        this.frame.setAutoRequestFocus(false);
        this.frame.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.frame.dispose();
    }

    public static void create() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                INSTANCE = new DiagnosticPanel();
            }
        });
    }

    public static void refresh() {
        if (INSTANCE != null) {
            DataProxy.update();
        }
    }

    public static void destroy() {
        if (INSTANCE != null) {
            DataProxy.dataPools.clear();
            INSTANCE.close();
            INSTANCE = null;
        }
    }
}

