/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.weather;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.weather.StormSplashRenderer;
import org.blockartistry.DynSurround.client.weather.Weather;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.gfx.ParticleHelper;

@SideOnly(value=Side.CLIENT)
public class NetherSplashRenderer
extends StormSplashRenderer {
    @Override
    protected SoundEvent getBlockSoundFX(Block block2, boolean hasDust, World world) {
        return hasDust ? Weather.getWeatherProperties().getDustSound() : null;
    }

    @Override
    protected void spawnBlockParticle(IBlockState state, boolean dust, World world, double x, double y, double z) {
        if (dust) {
            ParticleHelper.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, x, y, z);
        }
    }

    @Override
    protected BlockPos getPrecipitationHeight(World world, int range, BlockPos pos) {
        int y = EnvironStateHandler.EnvironState.getPlayerPosition().func_177956_o();
        boolean airBlockFound = false;
        for (int i = range; i >= -range; --i) {
            IBlockState state = WorldUtils.getBlockState(world, pos.func_177958_n(), y + i, pos.func_177952_p());
            Material material = state.func_185904_a();
            if (airBlockFound && material != Material.field_151579_a && material.func_76220_a()) {
                return new BlockPos(pos.func_177958_n(), y + i + 1, pos.func_177952_p());
            }
            if (material != Material.field_151579_a) continue;
            airBlockFound = true;
        }
        return new BlockPos(pos.func_177958_n(), 128, pos.func_177952_p());
    }
}

