/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.weather;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.fx.ParticleCollections;
import org.blockartistry.DynSurround.client.handlers.SoundEffectHandler;
import org.blockartistry.DynSurround.client.sound.AdhocSound;
import org.blockartistry.DynSurround.client.weather.NetherSplashRenderer;
import org.blockartistry.DynSurround.client.weather.NullSplashRenderer;
import org.blockartistry.DynSurround.client.weather.RenderWeather;
import org.blockartistry.DynSurround.client.weather.Weather;
import org.blockartistry.DynSurround.client.weather.compat.RandomThings;
import org.blockartistry.DynSurround.registry.BiomeInfo;
import org.blockartistry.lib.WorldUtils;
import org.blockartistry.lib.gfx.ParticleHelper;
import org.blockartistry.lib.random.XorShiftRandom;
import org.blockartistry.lib.sound.BasicSound;

@SideOnly(value=Side.CLIENT)
public class StormSplashRenderer {
    protected static final int PARTICLE_SOUND_CHANCE = 3;
    private static final TIntObjectHashMap<StormSplashRenderer> splashRenderers = new TIntObjectHashMap();
    private static final StormSplashRenderer DEFAULT = new StormSplashRenderer();
    protected final Random RANDOM = new XorShiftRandom();
    protected final NoiseGeneratorSimplex GENERATOR = new NoiseGeneratorSimplex(this.RANDOM);
    protected final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    protected int rainSoundCounter = 0;

    public static void renderStormSplashes(int dimensionId, EntityRenderer renderer) {
        StormSplashRenderer splash = (StormSplashRenderer)splashRenderers.get(dimensionId);
        if (splash == null) {
            splash = DEFAULT;
        }
        splash.addRainParticles(renderer);
    }

    protected StormSplashRenderer() {
    }

    protected float calculateRainSoundVolume(World world) {
        float currentVolume = Weather.getCurrentVolume();
        float bounds = currentVolume * 0.25f;
        float adjust = MathHelper.func_76131_a((float)((float)(this.GENERATOR.func_151605_a((double)(world.func_72820_D() % 24000L / 100L), 1.0) / 5.0)), (float)(-bounds), (float)bounds);
        return MathHelper.func_76131_a((float)(currentVolume + adjust), (float)0.0f, (float)1.0f);
    }

    protected void spawnBlockParticle(IBlockState state, boolean dust, World world, double x, double y, double z) {
        Block block2 = state.func_177230_c();
        EnumParticleTypes particleType = null;
        if (dust || block2 == Blocks.field_150425_aM) {
            particleType = null;
        } else if ((block2 == Blocks.field_150424_aL || block2 == Blocks.field_189877_df) && this.RANDOM.nextInt(20) == 0) {
            particleType = EnumParticleTypes.LAVA;
        } else if (state.func_185904_a() == Material.field_151587_i) {
            particleType = EnumParticleTypes.SMOKE_NORMAL;
        } else if (WorldUtils.isFullWaterBlock(state)) {
            ParticleCollections.addWaterRipple(world, x, y, z);
        } else if (state.func_185904_a() != Material.field_151579_a) {
            ParticleCollections.addRainSplash(world, x, y, z);
        }
        if (particleType != null) {
            ParticleHelper.spawnParticle(particleType, x, y, z);
        }
    }

    protected SoundEvent getBlockSoundFX(Block block2, boolean hasDust, World world) {
        if (hasDust) {
            return Weather.getWeatherProperties().getDustSound();
        }
        if (block2 == Blocks.field_150424_aL) {
            return SoundEvents.field_187662_cZ;
        }
        return Weather.getWeatherProperties().getStormSound();
    }

    protected BlockPos getPrecipitationHeight(World world, int range, BlockPos pos) {
        return ClientRegistry.SEASON.getPrecipitationHeight(world, pos);
    }

    protected boolean biomeHasDust(Biome biome) {
        return ModOptions.fog.allowDesertFog && !Weather.doVanilla() && ClientRegistry.BIOME.get(biome).getHasDust();
    }

    protected void playSplashSound(EntityRenderer renderer, World world, Entity player2, double x, double y, double z) {
        this.pos.func_189532_c(x, y - 1.0, z);
        boolean hasDust = this.biomeHasDust(world.func_180494_b((BlockPos)this.pos));
        Block block2 = WorldUtils.getBlockState(world, (BlockPos)this.pos).func_177230_c();
        SoundEvent sound2 = this.getBlockSoundFX(block2, hasDust, world);
        if (sound2 != null) {
            float volume = this.calculateRainSoundVolume(world);
            float pitch = 1.0f;
            int playerY = MathHelper.func_76128_c((double)player2.field_70163_u);
            this.pos.func_189532_c(player2.field_70165_t, 0.0, player2.field_70161_v);
            if (y > player2.field_70163_u + 1.0 && this.getPrecipitationHeight(world, 0, (BlockPos)this.pos).func_177956_o() > playerY) {
                pitch = 0.5f;
            }
            this.pos.func_189532_c(x, y, z);
            AdhocSound fx = new AdhocSound(sound2, SoundCategory.WEATHER);
            ((BasicSound)((Object)((BasicSound)((Object)fx.setVolume(volume))).setPitch(pitch -= (this.RANDOM.nextFloat() - this.RANDOM.nextFloat()) * 0.1f))).setPosition((Vec3i)this.pos);
            SoundEffectHandler.INSTANCE.playSound(fx);
        }
    }

    public void addRainParticles(EntityRenderer theThis) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74362_aa == 2) {
            return;
        }
        WorldClient world = mc.field_71441_e;
        if (!ClientRegistry.DIMENSION.hasWeather((World)world)) {
            return;
        }
        float rainStrengthFactor = Weather.getIntensityLevel();
        if (!mc.field_71474_y.field_74347_j) {
            rainStrengthFactor /= 2.0f;
        }
        if (rainStrengthFactor <= 0.0f) {
            return;
        }
        this.RANDOM.setSeed((long)RenderWeather.rendererUpdateCount * 312987231L);
        Entity entity = mc.func_175606_aa();
        int playerX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int playerY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int playerZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        double spawnX = 0.0;
        double spawnY = 0.0;
        double spawnZ = 0.0;
        int particlesSpawned = 0;
        int RANGE = Math.max((ModOptions.general.specialEffectRange + 1) / 2, 10);
        float rangeFactor = (float)RANGE / 10.0f;
        int particleCount = (int)((float)ModOptions.rain.particleCountBase * rainStrengthFactor * rainStrengthFactor * rangeFactor);
        if (mc.field_71474_y.field_74362_aa == 1) {
            particleCount >>= 1;
        }
        for (int j1 = 0; j1 < particleCount; ++j1) {
            int locX = playerX + this.RANDOM.nextInt(RANGE) - this.RANDOM.nextInt(RANGE);
            int locZ = playerZ + this.RANDOM.nextInt(RANGE) - this.RANDOM.nextInt(RANGE);
            this.pos.func_181079_c(locX, 0, locZ);
            if (!RandomThings.shouldRain((World)world, (BlockPos)this.pos)) continue;
            BlockPos precipHeight = this.getPrecipitationHeight((World)world, RANGE / 2, (BlockPos)this.pos);
            BiomeInfo biome = ClientRegistry.BIOME.get(world.func_180494_b((BlockPos)this.pos));
            boolean hasDust = biome.getHasDust();
            boolean canSnow = ClientRegistry.SEASON.canWaterFreeze((World)world, precipHeight);
            if (precipHeight.func_177956_o() > playerY + RANGE || precipHeight.func_177956_o() < playerY - RANGE || !hasDust && (!biome.getHasPrecipitation() || canSnow)) continue;
            BlockPos blockPos = precipHeight.func_177977_b();
            IBlockState state = WorldUtils.getBlockState((World)world, blockPos);
            double posX = (float)locX + this.RANDOM.nextFloat();
            double posY = (double)((float)precipHeight.func_177956_o() + 0.1f) - state.func_185900_c((IBlockAccess)world, (BlockPos)blockPos).field_72338_b;
            double posZ = (float)locZ + this.RANDOM.nextFloat();
            this.spawnBlockParticle(state, hasDust, (World)world, posX, posY, posZ);
            if (this.RANDOM.nextInt(++particlesSpawned) != 0) continue;
            spawnX = posX;
            spawnY = posY;
            spawnZ = posZ;
        }
        if (particlesSpawned > 0 && this.RANDOM.nextInt(3) < this.rainSoundCounter++) {
            this.rainSoundCounter = 0;
            this.playSplashSound(theThis, (World)world, entity, spawnX, spawnY, spawnZ);
        }
    }

    static {
        splashRenderers.put(0, (Object)DEFAULT);
        splashRenderers.put(-1, (Object)new NetherSplashRenderer());
        splashRenderers.put(1, (Object)new NullSplashRenderer());
    }
}

