/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.client.weather.tracker;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.api.events.ThunderEvent;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.client.weather.Weather;
import org.blockartistry.DynSurround.client.weather.tracker.Tracker;
import org.blockartistry.lib.PlayerUtils;
import org.blockartistry.lib.TimeUtils;
import org.blockartistry.lib.math.MathStuff;
import org.blockartistry.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class SimulationTracker
extends Tracker {
    protected float intensityLevel = 0.0f;
    protected float maxIntensityLevel = 0.0f;
    protected int nextThunderEvent = 0;
    protected Weather.Properties intensity = Weather.Properties.NONE;
    protected Random random;

    @Override
    protected String type() {
        return "SIMULATION";
    }

    @Override
    @Nonnull
    public Weather.Properties getWeatherProperties() {
        return this.intensity;
    }

    @Override
    public float getIntensityLevel() {
        return this.intensityLevel;
    }

    @Override
    public float getMaxIntensityLevel() {
        return this.maxIntensityLevel;
    }

    @Override
    public int getNextThunderEvent() {
        return this.nextThunderEvent;
    }

    @Override
    public boolean doVanilla() {
        return false;
    }

    @Override
    public boolean backgroundThunderPossible() {
        if (!ModOptions.rain.allowBackgroundThunder) {
            return false;
        }
        int dimId = EnvironStateHandler.EnvironState.getDimensionId();
        return dimId != -1 && dimId != 1 && this.isThundering() && this.getIntensityLevel() >= ModOptions.rain.stormThunderThreshold;
    }

    @Override
    public void update() {
        if (ClientRegistry.DIMENSION.hasWeather(EnvironStateHandler.EnvironState.getWorld())) {
            this.updateRainState();
            this.doAmbientThunder();
        } else {
            this.intensity = Weather.Properties.NONE;
            this.intensityLevel = 0.0f;
            this.maxIntensityLevel = 0.0f;
            this.nextThunderEvent = 0;
        }
    }

    private void updateRainState() {
        float vanillaIntensity = super.getIntensityLevel();
        if (vanillaIntensity > 0.0f && this.intensityLevel == 0.0f) {
            float result;
            this.random = new XorShiftRandom(SimulationTracker.generateSeed());
            float delta = ModOptions.general.defaultMaxRainStrength - ModOptions.general.defaultMinRainStrength;
            if (delta <= 0.0f) {
                result = ModOptions.general.defaultMinRainStrength;
            } else {
                float mid = delta / 2.0f;
                result = ModOptions.general.defaultMinRainStrength + (this.random.nextFloat() + this.random.nextFloat()) * mid;
            }
            this.maxIntensityLevel = MathStuff.clamp(result, 0.01f, 1.0f);
        } else if (vanillaIntensity == 0.0f && this.intensityLevel > 0.0f) {
            this.maxIntensityLevel = 0.0f;
            this.nextThunderEvent = 0;
            this.random = null;
        }
        float newIntensity = MathStuff.clamp(vanillaIntensity, 0.0f, this.maxIntensityLevel);
        this.setCurrentIntensity(newIntensity);
    }

    protected void setCurrentIntensity(float level) {
        this.intensity = Weather.Properties.mapRainStrength(level);
        this.intensityLevel = this.intensity == Weather.Properties.VANILLA ? 0.0f : MathStuff.clamp(level, 0.0f, 1.0f);
    }

    private static long generateSeed() {
        return TimeUtils.getGMTDaySeedBase() + (long)EnvironStateHandler.EnvironState.getClock().getDay();
    }

    private void doAmbientThunder() {
        if (this.backgroundThunderPossible()) {
            float intensity = this.getIntensityLevel();
            int time = this.nextThunderEvent - 1;
            if (time <= 0) {
                EntityPlayer player2;
                if (time == 0 && (player2 = PlayerUtils.getRandomPlayer(EnvironStateHandler.EnvironState.getWorld())) != null) {
                    float theY = EnvironStateHandler.EnvironState.getDimensionInfo().getSkyHeight();
                    BlockPos pos = new BlockPos(player2.field_70165_t, (double)theY, player2.field_70161_v);
                    MinecraftForge.EVENT_BUS.post((Event)new ThunderEvent(player2.func_130014_f_(), this.doFlash(intensity), pos));
                }
                time = this.nextThunderEvent(intensity);
            }
            this.nextThunderEvent = time;
        } else {
            this.nextThunderEvent = 0;
        }
    }

    private int nextThunderEvent(float rainIntensity) {
        float scale = 2.0f - rainIntensity;
        return this.random.nextInt((int)(450.0f * scale)) + 300;
    }

    protected boolean doFlash(float rainIntensity) {
        int randee = (int)(rainIntensity * 100.0f);
        return this.random.nextInt(150) <= randee;
    }
}

