/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.data;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.event.ReloadEvent;
import org.blockartistry.Presets.api.ConfigurationHelper;
import org.blockartistry.Presets.api.PresetData;
import org.blockartistry.Presets.api.events.PresetEvent;
import org.blockartistry.lib.ConfigProcessor;

@SideOnly(value=Side.CLIENT)
public class PresetHandler {
    private static final Set<String> categoriesToIgnore = Sets.newHashSet();
    private static final ConfigurationHelper.IConfigFilter FILTER;

    @Optional.Method(modid="presets")
    @SubscribeEvent
    public static void presetSave(@Nonnull PresetEvent.Save event) {
        PresetData data = event.getModData("dsurround");
        ConfigurationHelper helper = new ConfigurationHelper(data);
        helper.save(DSurround.config(), FILTER);
    }

    @Optional.Method(modid="presets")
    @SubscribeEvent
    public static void presetLoad(@Nonnull PresetEvent.Load event) {
        PresetData data = event.getModData("dsurround");
        if (data != null) {
            ConfigurationHelper helper = new ConfigurationHelper(data);
            helper.load(DSurround.config(), FILTER);
            DSurround.config().save();
            ConfigProcessor.process(DSurround.config(), ModOptions.class);
            MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent.Configuration());
        }
    }

    static {
        categoriesToIgnore.add("asm");
        categoriesToIgnore.add("logging");
        FILTER = new ConfigurationHelper.IConfigFilter(){

            @Override
            public boolean skipCategory(@Nonnull ConfigCategory category) {
                return categoriesToIgnore.contains(category.getQualifiedName());
            }

            @Override
            public boolean skipProperty(@Nonnull ConfigCategory category, @Nonnull Property property) {
                return false;
            }
        };
    }
}

