/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.data;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import org.blockartistry.DynSurround.DSurround;

public enum Profiles {
    NO_NETHER_WEATHER("noNetherWeather", "No Nether Weather", "Disable weather effects in the Nether"),
    NO_DUST_EFFECTS("noDustEffects", "No Dust Effects", "Turns off dust effects for all biomes");

    private static final String PROFILE_PATH = "/assets/dsurround/profiles/";
    private final String root;
    private final String key;
    private final String desc;

    private Profiles(@Nonnull String rootName, String propName, String comment) {
        this.root = rootName;
        this.key = propName;
        this.desc = comment;
    }

    public boolean isEnabled() {
        ConfigCategory cat = DSurround.config().getCategory("profiles");
        Property prop = cat.get(this.key);
        if (prop == null) {
            prop = new Property(this.key, "false", Property.Type.BOOLEAN);
            cat.put(this.key, prop);
            prop.setValue(false);
        }
        prop.setComment(this.desc);
        prop.setLanguageKey("dsurround.cfg.profiles." + this.root);
        prop.setRequiresMcRestart(false);
        prop.setRequiresWorldRestart(false);
        prop.setDefaultValue(false);
        return prop.getBoolean();
    }

    private InputStream getStream() {
        String path = PROFILE_PATH + this.root + ".json";
        return Profiles.class.getResourceAsStream(path);
    }

    public static void tickle() {
        for (Profiles p : Profiles.values()) {
            p.isEnabled();
        }
    }

    public static List<ProfileScript> getProfileStreams() {
        ArrayList<ProfileScript> results = new ArrayList<ProfileScript>();
        for (Profiles p : Profiles.values()) {
            if (!p.isEnabled()) continue;
            results.add(new ProfileScript(p.name(), p.getStream()));
        }
        return results;
    }

    public static class ProfileScript {
        public final String packName;
        public final InputStream stream;

        public ProfileScript(@Nonnull String name, @Nonnull InputStream strm) {
            this.packName = name;
            this.stream = strm;
        }
    }
}

