/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.entity;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.blockartistry.DynSurround.api.entity.ActionState;
import org.blockartistry.DynSurround.api.entity.EmojiType;
import org.blockartistry.DynSurround.api.entity.EmotionalState;
import org.blockartistry.DynSurround.api.entity.IEmojiData;
import org.blockartistry.DynSurround.entity.EmojiData;
import org.blockartistry.DynSurround.entity.IEmojiDataSettable;
import org.blockartistry.DynSurround.network.Network;
import org.blockartistry.DynSurround.network.PacketEntityEmote;
import org.blockartistry.lib.capability.CapabilityProviderSerializable;

public class CapabilityEmojiData {
    @CapabilityInject(value=IEmojiData.class)
    public static final Capability<IEmojiData> EMOJI = null;
    public static final EnumFacing DEFAULT_FACING = null;
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("dsurround", "emojiData");

    public static void register() {
        CapabilityManager.INSTANCE.register(IEmojiData.class, (Capability.IStorage)new Capability.IStorage<IEmojiData>(){

            public NBTBase writeNBT(@Nonnull Capability<IEmojiData> capability, @Nonnull IEmojiData instance, @Nullable EnumFacing side) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("as", instance.getActionState().ordinal());
                nbt.func_74768_a("et", instance.getEmojiType().ordinal());
                nbt.func_74768_a("es", instance.getEmotionalState().ordinal());
                return nbt;
            }

            public void readNBT(@Nonnull Capability<IEmojiData> capability, @Nonnull IEmojiData instance, @Nullable EnumFacing side, @Nonnull NBTBase nbt) {
                NBTTagCompound data = (NBTTagCompound)nbt;
                IEmojiDataSettable settable = (IEmojiDataSettable)instance;
                settable.setActionState(ActionState.get(data.func_74762_e("as")));
                settable.setEmojiType(EmojiType.get(data.func_74762_e("et")));
                settable.setEmotionalState(EmotionalState.get(data.func_74762_e("es")));
                settable.clearDirty();
            }
        }, (Callable)new Callable<IEmojiData>(){

            @Override
            public IEmojiData call() throws Exception {
                return new EmojiData(null);
            }
        });
    }

    @Nonnull
    public static ICapabilityProvider createProvider(IEmojiData data) {
        return new CapabilityProviderSerializable<IEmojiData>(EMOJI, DEFAULT_FACING, data);
    }

    public static class EventHandler {
        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityLivingBase) {
                EmojiData emojiData = new EmojiData((Entity)event.getObject());
                event.addCapability(CAPABILITY_ID, CapabilityEmojiData.createProvider(emojiData));
            }
        }

        @SubscribeEvent
        public static void trackingEvent(@Nonnull PlayerEvent.StartTracking event) {
            IEmojiData data;
            if (event.getTarget() instanceof EntityLivingBase && (data = (IEmojiData)event.getTarget().getCapability(EMOJI, DEFAULT_FACING)) != null) {
                Network.sendToPlayer((EntityPlayerMP)event.getEntityPlayer(), new PacketEntityEmote(data));
            }
        }
    }
}

