/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.entity;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import org.blockartistry.DynSurround.api.entity.ActionState;
import org.blockartistry.DynSurround.api.entity.EmojiType;
import org.blockartistry.DynSurround.api.entity.EmotionalState;
import org.blockartistry.DynSurround.entity.IEmojiDataSettable;
import org.blockartistry.DynSurround.network.Network;
import org.blockartistry.DynSurround.network.PacketEntityEmote;

public final class EmojiData
implements IEmojiDataSettable {
    public static final int NO_ENTITY = -1;
    private final Entity entity;
    private boolean isDirty = false;
    private ActionState actionState = ActionState.NONE;
    private EmotionalState emotionalState = EmotionalState.NEUTRAL;
    private EmojiType emojiType = EmojiType.NONE;

    public EmojiData(@Nonnull Entity entity) {
        this.entity = entity;
    }

    @Override
    public int getEntityId() {
        return this.entity != null ? this.entity.func_145782_y() : -1;
    }

    @Override
    public void setActionState(@Nonnull ActionState state) {
        if (this.actionState != state) {
            this.actionState = state;
            this.isDirty = true;
        }
    }

    @Override
    public void setEmotionalState(EmotionalState state) {
        if (this.emotionalState != state) {
            this.emotionalState = state;
            this.isDirty = true;
        }
    }

    @Override
    public void setEmojiType(EmojiType type) {
        if (this.emojiType != type) {
            this.emojiType = type;
            this.isDirty = true;
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void clearDirty() {
        this.isDirty = false;
    }

    @Override
    @Nonnull
    public ActionState getActionState() {
        return this.actionState;
    }

    @Override
    @Nonnull
    public EmotionalState getEmotionalState() {
        return this.emotionalState;
    }

    @Override
    @Nonnull
    public EmojiType getEmojiType() {
        return this.emojiType;
    }

    @Override
    public void sync() {
        if (this.entity != null && !this.entity.field_70170_p.field_72995_K) {
            Network.sendToEntityViewers(this.entity, new PacketEntityEmote(this));
            this.clearDirty();
        }
    }
}

