/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.entity;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBeg;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIDefendVillage;
import net.minecraft.entity.ai.EntityAIDoorInteract;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIFollowGolem;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHarvestFarmland;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookAtTradePlayer;
import net.minecraft.entity.ai.EntityAILookAtVillager;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOcelotAttack;
import net.minecraft.entity.ai.EntityAIOcelotSit;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIPlay;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISkeletonRiders;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.ai.EntityAIVillagerInteract;
import net.minecraft.entity.ai.EntityAIVillagerMate;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityRabbit;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.api.entity.ActionState;
import org.blockartistry.DynSurround.api.entity.EmojiType;
import org.blockartistry.DynSurround.api.entity.EmotionalState;
import org.blockartistry.lib.compat.EntityLivingUtil;

public final class EmojiDataTables {
    private static final Map<Class<? extends EntityAIBase>, ActionState> actions = new IdentityHashMap<Class<? extends EntityAIBase>, ActionState>();
    private static final TIntObjectHashMap<EmojiType> emojiMap = new TIntObjectHashMap();

    private EmojiDataTables() {
    }

    private static int emojiIdx(@Nullable ActionState action, @Nullable EmotionalState emotion) {
        int aIdx = action != null ? action.ordinal() + 1 : 0;
        int eIdx = emotion != null ? emotion.ordinal() + 1 : 0;
        return aIdx << 8 | eIdx;
    }

    public static void add(@Nonnull Class<? extends EntityAIBase> clazz, @Nonnull ActionState state) {
        if (!actions.containsKey(clazz)) {
            actions.put(clazz, state);
        }
    }

    private static void registerSpecial(@Nonnull Class<? extends EntityLiving> clazz, @Nonnull String className, @Nonnull ActionState state) {
        Class<? extends EntityAIBase> ai = EmojiDataTables.findInternalClass(clazz, className);
        if (ai != null) {
            actions.put(ai, state);
        } else {
            DSurround.log().warn("Unable to locate class '%s' inside [%s]", className, clazz.toGenericString());
        }
    }

    private static Class<? extends EntityAIBase> findInternalClass(@Nonnull Class<? extends EntityLiving> clazz, @Nonnull String className) {
        Class<?>[] classes;
        for (Class<?> c : classes = clazz.getDeclaredClasses()) {
            if (!c.getName().endsWith(className) || !EntityAIBase.class.isAssignableFrom(c)) continue;
            return c;
        }
        return null;
    }

    @Nonnull
    private static ActionState eval(@Nonnull Set<EntityAITasks.EntityAITaskEntry> entries) {
        ActionState state = ActionState.NONE;
        for (EntityAITasks.EntityAITaskEntry task : entries) {
            ActionState candidate = actions.get(task.field_75733_a.getClass());
            if (candidate == null || state.getPriority() >= candidate.getPriority()) continue;
            state = candidate;
        }
        return state;
    }

    @Nonnull
    public static ActionState assess(@Nonnull EntityLiving entity) {
        ActionState result;
        ActionState first = EmojiDataTables.eval(entity.field_70714_bg.field_75780_b);
        ActionState second = EmojiDataTables.eval(entity.field_70715_bh.field_75780_b);
        ActionState actionState = result = first.getPriority() > second.getPriority() ? first : second;
        if (EntityLivingUtil.getAttackTarget(entity) != null && ActionState.ATTACKING.getPriority() > result.getPriority()) {
            result = ActionState.ATTACKING;
        }
        return result;
    }

    @Nonnull
    public static EmojiType getEmoji(@Nullable ActionState action, @Nullable EmotionalState emotion) {
        EmojiType type = (EmojiType)((Object)emojiMap.get(EmojiDataTables.emojiIdx(action, emotion)));
        if (type == null) {
            type = (EmojiType)((Object)emojiMap.get(EmojiDataTables.emojiIdx(action, null)));
        }
        if (type == null) {
            type = (EmojiType)((Object)emojiMap.get(EmojiDataTables.emojiIdx(null, emotion)));
        }
        return type != null ? type : EmojiType.NONE;
    }

    static {
        EmojiDataTables.add(EntityAIAttackMelee.class, ActionState.ATTACKING);
        EmojiDataTables.add(EntityAIAttackRanged.class, ActionState.ATTACKING);
        EmojiDataTables.add(EntityAIAttackRangedBow.class, ActionState.ATTACKING);
        EmojiDataTables.add(EntityAIAvoidEntity.class, ActionState.PANIC);
        EmojiDataTables.add(EntityAIBeg.class, ActionState.BEGGING);
        EmojiDataTables.add(EntityAIBreakDoor.class, ActionState.NONE);
        EmojiDataTables.add(EntityAICreeperSwell.class, ActionState.EXPLODE);
        EmojiDataTables.add(EntityAIDefendVillage.class, ActionState.NONE);
        EmojiDataTables.add(EntityAIDoorInteract.class, ActionState.NONE);
        EmojiDataTables.add(EntityAIEatGrass.class, ActionState.EATING);
        EmojiDataTables.add(EntityAIFindEntityNearest.class, ActionState.LOOKING);
        EmojiDataTables.add(EntityAIFindEntityNearestPlayer.class, ActionState.LOOKING);
        EmojiDataTables.add(EntityAIFleeSun.class, ActionState.PANIC);
        EmojiDataTables.add(EntityAIFollowGolem.class, ActionState.FOLLOWING);
        EmojiDataTables.add(EntityAIFollowOwner.class, ActionState.FOLLOWING);
        EmojiDataTables.add(EntityAIFollowParent.class, ActionState.FOLLOWING);
        EmojiDataTables.add(EntityAIHarvestFarmland.class, ActionState.FARMING);
        EmojiDataTables.add(EntityAIHurtByTarget.class, ActionState.ANGRY);
        EmojiDataTables.add(EntityAILeapAtTarget.class, ActionState.ATTACKING);
        EmojiDataTables.add(EntityAILookAtTradePlayer.class, ActionState.LOOKING);
        EmojiDataTables.add(EntityAILookAtVillager.class, ActionState.LOOKING);
        EmojiDataTables.add(EntityAILookIdle.class, ActionState.IDLE);
        EmojiDataTables.add(EntityAIMate.class, ActionState.MATING);
        EmojiDataTables.add(EntityAIMoveIndoors.class, ActionState.MOVING);
        EmojiDataTables.add(EntityAIMoveThroughVillage.class, ActionState.MOVING);
        EmojiDataTables.add(EntityAIMoveToBlock.class, ActionState.MOVING);
        EmojiDataTables.add(EntityAIMoveTowardsRestriction.class, ActionState.MOVING);
        EmojiDataTables.add(EntityAIMoveTowardsTarget.class, ActionState.MOVING);
        EmojiDataTables.add(EntityAINearestAttackableTarget.class, ActionState.NONE);
        EmojiDataTables.add(EntityAIOcelotAttack.class, ActionState.ATTACKING);
        EmojiDataTables.add(EntityAIOcelotSit.class, ActionState.IDLE);
        EmojiDataTables.add(EntityAIOpenDoor.class, ActionState.IDLE);
        EmojiDataTables.add(EntityAIOwnerHurtByTarget.class, ActionState.ATTACKING);
        EmojiDataTables.add(EntityAIPanic.class, ActionState.PANIC);
        EmojiDataTables.add(EntityAIPlay.class, ActionState.PLAYING);
        EmojiDataTables.add(EntityAIRestrictOpenDoor.class, ActionState.NONE);
        EmojiDataTables.add(EntityAIRestrictSun.class, ActionState.NONE);
        EmojiDataTables.add(EntityAIRunAroundLikeCrazy.class, ActionState.CRAZY);
        EmojiDataTables.add(EntityAISit.class, ActionState.IDLE);
        EmojiDataTables.add(EntityAISkeletonRiders.class, ActionState.NONE);
        EmojiDataTables.add(EntityAISwimming.class, ActionState.MOVING);
        EmojiDataTables.add(EntityAITarget.class, ActionState.NONE);
        EmojiDataTables.add(EntityAITargetNonTamed.class, ActionState.NONE);
        EmojiDataTables.add(EntityAITempt.class, ActionState.TEMPT);
        EmojiDataTables.add(EntityAITradePlayer.class, ActionState.TRADING);
        EmojiDataTables.add(EntityAIVillagerInteract.class, ActionState.NONE);
        EmojiDataTables.add(EntityAIVillagerMate.class, ActionState.MATING);
        EmojiDataTables.add(EntityAIWander.class, ActionState.MOVING);
        EmojiDataTables.add(EntityAIWatchClosest.class, ActionState.LOOKING);
        EmojiDataTables.add(EntityAIWatchClosest2.class, ActionState.LOOKING);
        EmojiDataTables.add(EntityAIZombieAttack.class, ActionState.NONE);
        EmojiDataTables.registerSpecial(EntityEnderman.class, "AIFindPlayer", ActionState.ANGRY);
        EmojiDataTables.registerSpecial(EntityGhast.class, "AIFireballAttack", ActionState.ATTACKING);
        EmojiDataTables.registerSpecial(EntityGuardian.class, "AIGuardianAttack", ActionState.ATTACKING);
        EmojiDataTables.registerSpecial(EntityPolarBear.class, "AIMeleeAttack", ActionState.ATTACKING);
        EmojiDataTables.registerSpecial(EntityPolarBear.class, "AIPanic", ActionState.PANIC);
        EmojiDataTables.registerSpecial(EntityPolarBear.class, "AIAttackPlayer", ActionState.ATTACKING);
        EmojiDataTables.registerSpecial(EntityShulker.class, "AIAttackNearest", ActionState.ATTACKING);
        EmojiDataTables.registerSpecial(EntitySlime.class, "AISlimeAttack", ActionState.ATTACKING);
        EmojiDataTables.registerSpecial(EntitySlime.class, "AISlimeHop", ActionState.MOVING);
        EmojiDataTables.registerSpecial(EntitySpider.class, "AISpiderAttack", ActionState.ATTACKING);
        EmojiDataTables.registerSpecial(EntityRabbit.class, "AIAvoidEntity", ActionState.CRAZY);
        EmojiDataTables.registerSpecial(EntityRabbit.class, "AIRaidFarm", ActionState.EATING);
        emojiMap.put(EmojiDataTables.emojiIdx(ActionState.ATTACKING, null), (Object)EmojiType.ATTACK);
        emojiMap.put(EmojiDataTables.emojiIdx(ActionState.EXPLODE, null), (Object)EmojiType.ANGRY);
        emojiMap.put(EmojiDataTables.emojiIdx(ActionState.PANIC, null), (Object)EmojiType.FLEE);
        emojiMap.put(EmojiDataTables.emojiIdx(ActionState.CRAZY, null), (Object)EmojiType.FLEE);
        emojiMap.put(EmojiDataTables.emojiIdx(ActionState.LOOKING, null), (Object)EmojiType.WATCH);
        emojiMap.put(EmojiDataTables.emojiIdx(null, EmotionalState.HAPPY), (Object)EmojiType.HAPPY);
        emojiMap.put(EmojiDataTables.emojiIdx(null, EmotionalState.SAD), (Object)EmojiType.SAD);
        emojiMap.put(EmojiDataTables.emojiIdx(null, EmotionalState.SICK), (Object)EmojiType.SICK);
        emojiMap.put(EmojiDataTables.emojiIdx(null, EmotionalState.HURT), (Object)EmojiType.HURT);
        emojiMap.put(EmojiDataTables.emojiIdx(ActionState.FARMING, null), (Object)EmojiType.FARM);
        emojiMap.put(EmojiDataTables.emojiIdx(null, EmotionalState.BUSY), (Object)EmojiType.WORK);
        emojiMap.put(EmojiDataTables.emojiIdx(ActionState.TRADING, null), (Object)EmojiType.TRADE);
        emojiMap.put(EmojiDataTables.emojiIdx(null, EmotionalState.ANGRY), (Object)EmojiType.ANGRY);
        emojiMap.put(EmojiDataTables.emojiIdx(ActionState.EATING, null), (Object)EmojiType.EAT);
        emojiMap.put(EmojiDataTables.emojiIdx(ActionState.WORKING, null), (Object)EmojiType.WORK);
    }
}

