/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.entity.ai;

import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import org.blockartistry.DynSurround.api.entity.EmotionalState;
import org.blockartistry.DynSurround.entity.CapabilityEmojiData;
import org.blockartistry.DynSurround.entity.EmojiDataTables;
import org.blockartistry.DynSurround.entity.IEmojiDataSettable;
import org.blockartistry.lib.EntityUtils;

public class EntityAIEmoji
extends EntityAIBase {
    public static final int PRIORITY = 400;
    protected final EntityLiving subject;
    protected IEmojiDataSettable data;

    public EntityAIEmoji(EntityLiving subject) {
        this.subject = subject;
    }

    public boolean func_75250_a() {
        return true;
    }

    public void func_75249_e() {
    }

    public void func_75246_d() {
        if (this.data == null) {
            this.data = (IEmojiDataSettable)this.subject.getCapability(CapabilityEmojiData.EMOJI, CapabilityEmojiData.DEFAULT_FACING);
        }
        if (this.data == null) {
            return;
        }
        this.updateActionState();
        this.updateEmotionalState();
        this.updateEmoji();
        if (this.data.isDirty()) {
            this.data.sync();
        }
    }

    protected void updateActionState() {
        this.data.setActionState(EmojiDataTables.assess(this.subject));
    }

    protected void updateEmotionalState() {
        EmotionalState newState = this.data.getActionState().getEmotionalState();
        if (EntityUtils.hasNegativePotionEffects(this.subject)) {
            newState = EmotionalState.SICK;
        } else if (this.subject.func_110143_aJ() <= this.subject.func_110138_aP() / 2.0f) {
            newState = EmotionalState.HURT;
        }
        this.data.setEmotionalState(newState);
    }

    protected void updateEmoji() {
        if (this.data.isDirty()) {
            this.data.setEmojiType(EmojiDataTables.getEmoji(this.data.getActionState(), this.data.getEmotionalState()));
        }
    }
}

