/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.facade;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.facade.FacadeHelper;

final class EnderIOFacadeAccessor
implements FacadeHelper.IFacadeAccessor {
    private static final String CLASS = "crazypants.enderio.paint.IPaintable";
    private static final String METHOD = "getPaintSource";
    private static Class<?> IFacadeClass;
    private static Method method;

    EnderIOFacadeAccessor() {
    }

    @Override
    @Nullable
    public IBlockState getBlockState(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        if (IFacadeClass == null || method == null) {
            return null;
        }
        Block block2 = state.func_177230_c();
        try {
            if (IFacadeClass.isInstance(block2)) {
                return (IBlockState)method.invoke((Object)block2, state, world, pos);
            }
        }
        catch (Exception ex) {
            DSurround.log().warn("Unable to invoke %s.%s()", CLASS, METHOD);
            DSurround.log().catching(ex);
            method = null;
        }
        return null;
    }

    static {
        try {
            IFacadeClass = Class.forName(CLASS);
            if (IFacadeClass != null) {
                method = IFacadeClass.getMethod(METHOD, IBlockState.class, IBlockAccess.class, BlockPos.class);
            }
        }
        catch (Throwable t) {
            DSurround.log().warn("Unable to locate %s.%s()", CLASS, METHOD);
        }
    }
}

