/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.facade;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.blockartistry.DynSurround.facade.ChiselAPIFacadeAccessor;
import org.blockartistry.DynSurround.facade.ChiselFacadeAccessor;
import org.blockartistry.DynSurround.facade.CoFHCoreCoverAccessor;
import org.blockartistry.DynSurround.facade.EnderIOFacadeAccessor;
import org.blockartistry.lib.compat.ModEnvironment;

public final class FacadeHelper {
    private static final List<IFacadeAccessor> accessors = new ArrayList<IFacadeAccessor>();

    protected FacadeHelper() {
    }

    @Nonnull
    public static IBlockState resolveState(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        for (int i = 0; i < accessors.size(); ++i) {
            IBlockState newState = accessors.get(i).getBlockState(state, world, pos, side);
            if (newState == null) continue;
            return newState;
        }
        return state;
    }

    static {
        if (ModEnvironment.ChiselAPI.isLoaded()) {
            accessors.add(new ChiselAPIFacadeAccessor());
        } else if (ModEnvironment.Chisel.isLoaded()) {
            accessors.add(new ChiselFacadeAccessor());
        }
        if (ModEnvironment.EnderIO.isLoaded()) {
            accessors.add(new EnderIOFacadeAccessor());
        }
        if (ModEnvironment.CoFHCore.isLoaded()) {
            accessors.add(new CoFHCoreCoverAccessor());
        }
    }

    public static interface IFacadeAccessor {
        public IBlockState getBlockState(@Nonnull IBlockState var1, @Nonnull World var2, @Nonnull BlockPos var3, @Nullable EnumFacing var4);
    }
}

