/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.event.PlayDistributedSoundEvent;
import org.blockartistry.DynSurround.network.Locus;
import org.blockartistry.DynSurround.network.Network;
import org.blockartistry.lib.sound.BasicSound;

public class PacketPlaySound
implements IMessage {
    private static final int RANGE = 16;
    protected Locus locus;
    protected String soundClass;
    protected NBTTagCompound nbt = new NBTTagCompound();

    public PacketPlaySound() {
    }

    @SideOnly(value=Side.CLIENT)
    public PacketPlaySound(@Nonnull Entity entity, @Nonnull BasicSound<?> sound2) {
        this.locus = new Locus(entity, sound2.getLocusPosition(), 16.0);
        this.soundClass = ((Object)sound2).getClass().getName();
        this.nbt = sound2.serializeNBT();
    }

    public void fromBytes(@Nonnull ByteBuf buf) {
        this.locus = new Locus(buf);
        this.soundClass = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(@Nonnull ByteBuf buf) {
        this.locus.toBytes(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.soundClass);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public static class PacketHandlerServer
    implements IMessageHandler<PacketPlaySound, IMessage> {
        @Nullable
        public IMessage onMessage(@Nonnull PacketPlaySound message, @Nullable MessageContext ctx) {
            Network.sendToAllAround(message.locus, message);
            return null;
        }
    }

    public static class PacketHandler
    implements IMessageHandler<PacketPlaySound, IMessage> {
        @Nullable
        public IMessage onMessage(@Nonnull PacketPlaySound message, @Nullable MessageContext ctx) {
            if (!message.locus.isAssociatedEntity((Entity)EnvironStateHandler.EnvironState.getPlayer())) {
                Network.postEvent(new PlayDistributedSoundEvent(message.soundClass, message.nbt));
            }
            return null;
        }
    }
}

