/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.network;

import gnu.trove.iterator.TIntDoubleIterator;
import gnu.trove.map.hash.TIntDoubleHashMap;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.blockartistry.DynSurround.event.ServerDataEvent;
import org.blockartistry.DynSurround.network.Network;

public class PacketServerData
implements IMessage {
    private double meanTickTime;
    private TIntDoubleHashMap tMap;
    private int free;
    private int total;
    private int max;

    public PacketServerData() {
    }

    public PacketServerData(@Nonnull TIntDoubleHashMap tps, double meanTickTime, int memFree, int memTotal, int memMax) {
        this.meanTickTime = meanTickTime;
        this.tMap = tps;
        this.free = memFree;
        this.total = memTotal;
        this.max = memMax;
    }

    public void fromBytes(@Nonnull ByteBuf buf) {
        this.meanTickTime = buf.readDouble();
        int len = buf.readInt();
        this.tMap = new TIntDoubleHashMap(len);
        while (len-- != 0) {
            this.tMap.put(buf.readInt(), buf.readDouble());
        }
        this.free = buf.readInt();
        this.total = buf.readInt();
        this.max = buf.readInt();
    }

    public void toBytes(@Nonnull ByteBuf buf) {
        buf.writeDouble(this.meanTickTime);
        buf.writeInt(this.tMap.size());
        TIntDoubleIterator i = this.tMap.iterator();
        while (i.hasNext()) {
            i.advance();
            buf.writeInt(i.key());
            buf.writeDouble(i.value());
        }
        buf.writeInt(this.free);
        buf.writeInt(this.total);
        buf.writeInt(this.max);
    }

    public static class PacketHandler
    implements IMessageHandler<PacketServerData, IMessage> {
        @Nullable
        public IMessage onMessage(@Nonnull PacketServerData message, @Nullable MessageContext ctx) {
            Network.postEvent(new ServerDataEvent(message.tMap, message.meanTickTime, message.free, message.total, message.max));
            return null;
        }
    }
}

