/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.blockartistry.DynSurround.api.events.WeatherUpdateEvent;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.network.Network;

public final class PacketWeatherUpdate
implements IMessage {
    private float intensity;
    private float maxIntensity;
    private int nextRainChange;
    private float thunderStrength;
    private int thunderChange;
    private int thunderEvent;
    private int dimension;

    public PacketWeatherUpdate() {
    }

    public PacketWeatherUpdate(int dimension, float intensity, float maxIntensity, int nextRainChange, float thunderStrength, int thunderChange, int thunderEvent) {
        this.dimension = dimension;
        this.intensity = intensity;
        this.maxIntensity = maxIntensity;
        this.nextRainChange = nextRainChange;
        this.thunderStrength = thunderStrength;
        this.thunderChange = thunderChange;
        this.thunderEvent = thunderEvent;
    }

    public void fromBytes(@Nonnull ByteBuf buf) {
        this.dimension = buf.readShort();
        this.intensity = buf.readFloat();
        this.maxIntensity = buf.readFloat();
        this.nextRainChange = buf.readInt();
        this.thunderStrength = buf.readFloat();
        this.thunderChange = buf.readInt();
        this.thunderEvent = buf.readInt();
    }

    public void toBytes(@Nonnull ByteBuf buf) {
        buf.writeShort(this.dimension);
        buf.writeFloat(this.intensity);
        buf.writeFloat(this.maxIntensity);
        buf.writeInt(this.nextRainChange);
        buf.writeFloat(this.thunderStrength);
        buf.writeInt(this.thunderChange);
        buf.writeInt(this.thunderEvent);
    }

    public static class PacketHandler
    implements IMessageHandler<PacketWeatherUpdate, IMessage> {
        @Nullable
        public IMessage onMessage(@Nonnull PacketWeatherUpdate message, @Nullable MessageContext ctx) {
            World world = EnvironStateHandler.EnvironState.getWorld();
            if (world != null && world.field_73011_w != null && world.field_73011_w.getDimension() == message.dimension) {
                Network.postEvent(new WeatherUpdateEvent(world, message.intensity, message.maxIntensity, message.nextRainChange, message.thunderStrength, message.thunderChange, message.thunderEvent));
            }
            return null;
        }
    }
}

