/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.packs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.packs.Manifest;
import org.blockartistry.lib.JsonUtils;

public final class ResourcePacks {
    public static final ResourceLocation MANIFEST_RESOURCE = new ResourceLocation("dsurround", "manifest.json");
    public static final ResourceLocation ACOUSTICS_RESOURCE = new ResourceLocation("dsurround", "acoustics.json");
    public static final ResourceLocation PRIMITIVEMAP_RESOURCE = new ResourceLocation("dsurround", "primitivemap.json");
    public static final ResourceLocation CONFIGURE_RESOURCE = new ResourceLocation("dsurround", "configure.json");

    private ResourcePacks() {
    }

    @Nonnull
    public static List<Pack> findResourcePacks() {
        ArrayList<Pack> foundEntries = new ArrayList<Pack>();
        Pack p = new Pack("dsurround");
        if (!p.hasManifest()) {
            throw new RuntimeException("Missing configuration!");
        }
        foundEntries.add(p);
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (mod.getModId().equals("dsurround") || !(p = new Pack(mod.getModId())).hasManifest()) continue;
            foundEntries.add(p);
        }
        if (!DSurround.proxy().isRunningAsServer()) {
            List repo = Minecraft.func_71410_x().func_110438_M().func_110613_c();
            for (ResourcePackRepository.Entry pack : repo) {
                p = new ResourcePack(pack.func_110514_c());
                if (!p.hasManifest()) continue;
                foundEntries.add(p);
            }
        }
        return foundEntries;
    }

    private static class ResourcePack
    extends Pack {
        protected final IResourcePack pack;

        public ResourcePack(@Nonnull IResourcePack resource) {
            super(resource.func_130077_b());
            this.pack = resource;
        }

        @Override
        public InputStream getInputStream(@Nonnull ResourceLocation loc) throws IOException {
            return this.pack.func_110590_a(loc);
        }

        @Override
        public boolean resourceExists(@Nonnull ResourceLocation loc) {
            return this.pack.func_110589_b(loc);
        }
    }

    public static class Pack {
        protected final String modName;
        protected final String packPath;
        protected Manifest manifest;

        public Pack(@Nonnull String modName) {
            this.modName = modName;
            this.packPath = "/assets/" + modName + "/";
        }

        public boolean hasManifest() {
            if (this.manifest == null) {
                try (InputStream stream = this.getInputStream(MANIFEST_RESOURCE);){
                    if (stream != null) {
                        this.manifest = JsonUtils.load(stream, Manifest.class);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.manifest != null;
        }

        @Nonnull
        public String getModName() {
            return this.modName;
        }

        @Nullable
        public Manifest getManifest() {
            return this.manifest;
        }

        public InputStream getInputStream(@Nonnull ResourceLocation loc) throws IOException {
            StringBuilder builder = new StringBuilder();
            builder.append(this.packPath);
            builder.append(loc.func_110624_b()).append('/').append(loc.func_110623_a());
            return DSurround.class.getResourceAsStream(builder.toString());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean resourceExists(@Nonnull ResourceLocation loc) {
            try (InputStream stream = this.getInputStream(loc);){
                boolean bl = stream != null;
                return bl;
            }
            catch (Throwable throwable6) {
                return false;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Resource pack ").append(this.getModName()).append(": ");
            if (this.manifest != null) {
                builder.append(String.format("%s by %s (%s)", this.manifest.getName(), this.manifest.getAuthor(), this.manifest.getWebsite()));
            } else {
                builder.append("No manifest");
            }
            return builder.toString();
        }
    }
}

