/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.proxy;

import javax.annotation.Nonnull;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.commands.CommandDS;
import org.blockartistry.DynSurround.entity.CapabilityEmojiData;
import org.blockartistry.DynSurround.network.Network;
import org.blockartistry.DynSurround.registry.RegistryManager;
import org.blockartistry.DynSurround.server.services.ServiceManager;
import org.blockartistry.lib.Localization;
import org.blockartistry.lib.compat.ModEnvironment;

public class Proxy {
    protected long connectionTime = 0L;

    protected void registerLanguage() {
        Localization.initialize(Side.SERVER);
    }

    protected static void register(Class<?> clazz) {
        DSurround.log().info("Registering for Forge events: %s", clazz.getName());
        MinecraftForge.EVENT_BUS.register(clazz);
    }

    protected void eventBusRegistrations() {
        Proxy.register(CapabilityEmojiData.EventHandler.class);
        Proxy.register(RegistryManager.class);
    }

    public long currentSessionDuration() {
        return System.currentTimeMillis() - this.connectionTime;
    }

    public boolean isRunningAsServer() {
        return true;
    }

    public Side effectiveSide() {
        return Side.SERVER;
    }

    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        this.registerLanguage();
        this.eventBusRegistrations();
        CapabilityEmojiData.register();
    }

    public void init(@Nonnull FMLInitializationEvent event) {
        ModEnvironment.initialize();
        Network.initialize();
    }

    public void postInit(@Nonnull FMLPostInitializationEvent event) {
    }

    public void loadCompleted(@Nonnull FMLLoadCompleteEvent event) {
    }

    public void clientConnect(@Nonnull FMLNetworkEvent.ClientConnectedToServerEvent event) {
    }

    public void clientDisconnect(@Nonnull FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
    }

    public void serverAboutToStart(@Nonnull FMLServerAboutToStartEvent event) {
        ServiceManager.initialize();
    }

    public void serverStarting(@Nonnull FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ICommandManager command = server.func_71187_D();
        ServerCommandManager serverCommand = (ServerCommandManager)command;
        serverCommand.func_71560_a((ICommand)new CommandDS());
    }

    public void serverStopping(@Nonnull FMLServerStoppingEvent event) {
    }

    public void serverStopped(@Nonnull FMLServerStoppedEvent event) {
        ServiceManager.deinitialize();
    }
}

