/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.data.xface.BiomeConfig;
import org.blockartistry.DynSurround.data.xface.SoundConfig;
import org.blockartistry.DynSurround.data.xface.SoundType;
import org.blockartistry.DynSurround.registry.FakeBiome;
import org.blockartistry.DynSurround.registry.IBiome;
import org.blockartistry.DynSurround.registry.TemperatureRating;
import org.blockartistry.lib.BiomeUtils;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.MyUtils;
import org.blockartistry.lib.WeightTable;
import org.blockartistry.lib.compat.ModEnvironment;

@SideOnly(value=Side.CLIENT)
public final class BiomeInfo
implements Comparable<BiomeInfo> {
    private static Class<?> bopBiome = null;
    private static Field bopBiomeFogDensity = null;
    private static Field bopBiomeFogColor = null;
    public static final int DEFAULT_SPOT_CHANCE = 250;
    public static final SoundEffect[] NO_SOUNDS;
    protected final IBiome biome;
    protected boolean hasPrecipitation;
    protected boolean hasDust;
    protected boolean hasAurora;
    protected boolean hasFog;
    private Color dustColor;
    private Color fogColor;
    private float fogDensity;
    protected SoundEffect[] sounds = NO_SOUNDS;
    protected SoundEffect[] spotSounds = NO_SOUNDS;
    protected int spotSoundChance = 250;
    protected final List<String> comments = Lists.newArrayList();
    protected final boolean isRiver;
    protected final boolean isOcean;
    protected final boolean isDeepOcean;

    public BiomeInfo(@Nonnull IBiome biome) {
        this.biome = biome;
        if (!this.isFake()) {
            boolean bl = this.hasPrecipitation = this.canRain() || this.getEnableSnow();
        }
        if (bopBiome != null && bopBiome.isInstance(biome)) {
            try {
                int color = bopBiomeFogColor.getInt(biome);
                if (color > 0) {
                    this.hasFog = true;
                    this.fogColor = new Color(color);
                    this.fogDensity = bopBiomeFogDensity.getFloat(biome);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isRiver = this.biome.getTypes().contains(BiomeDictionary.Type.RIVER);
        this.isOcean = this.biome.getTypes().contains(BiomeDictionary.Type.OCEAN);
        this.isDeepOcean = this.isOcean && this.getBiomeName().matches("(?i).*deep.*ocean.*|.*abyss.*");
    }

    public boolean isRiver() {
        return this.isRiver;
    }

    public boolean isOcean() {
        return this.isOcean;
    }

    public boolean isDeepOcean() {
        return this.isDeepOcean;
    }

    public ResourceLocation getKey() {
        return this.biome.getKey();
    }

    public int getBiomeId() {
        return this.biome.getId();
    }

    public Set<BiomeDictionary.Type> getBiomeTypes() {
        return this.biome.getTypes();
    }

    void addComment(@Nonnull String comment) {
        if (!StringUtils.isEmpty((CharSequence)comment)) {
            this.comments.add(comment);
        }
    }

    public List<String> getComments() {
        return this.comments;
    }

    public String getBiomeName() {
        return this.biome.getName();
    }

    public boolean hasWeatherEffect() {
        return this.getHasPrecipitation() || this.getHasDust();
    }

    public boolean getHasPrecipitation() {
        return this.hasPrecipitation;
    }

    public boolean canRain() {
        return this.biome.canRain();
    }

    public boolean getEnableSnow() {
        return this.biome.getEnableSnow();
    }

    void setHasPrecipitation(boolean flag) {
        this.hasPrecipitation = flag;
    }

    public boolean getHasDust() {
        return this.hasDust;
    }

    void setHasDust(boolean flag) {
        this.hasDust = flag;
    }

    public boolean getHasAurora() {
        return this.hasAurora;
    }

    void setHasAurora(boolean flag) {
        this.hasAurora = flag;
    }

    public boolean getHasFog() {
        return this.hasFog;
    }

    void setHasFog(boolean flag) {
        this.hasFog = flag;
    }

    public Color getDustColor() {
        return this.dustColor;
    }

    void setDustColor(Color color) {
        this.dustColor = color;
    }

    public Color getFogColor() {
        return this.fogColor;
    }

    void setFogColor(@Nonnull Color color) {
        this.fogColor = color;
    }

    public float getFogDensity() {
        return this.fogDensity;
    }

    void setFogDensity(float density) {
        this.fogDensity = density;
    }

    void setSpotSoundChance(int chance) {
        this.spotSoundChance = chance;
    }

    void addSound(SoundEffect sound2) {
        this.sounds = MyUtils.append(this.sounds, sound2);
    }

    void addSpotSound(SoundEffect sound2) {
        this.spotSounds = MyUtils.append(this.spotSounds, sound2);
    }

    public boolean isFake() {
        return this.biome instanceof FakeBiome;
    }

    public float getFloatTemperature(@Nonnull BlockPos pos) {
        return this.biome.getFloatTemperature(pos);
    }

    public float getTemperature() {
        return this.biome.getTemperature();
    }

    public Biome.TempCategory getTempCategory() {
        return this.biome.getTempCategory();
    }

    public TemperatureRating getTemperatureRating() {
        return TemperatureRating.fromTemp(this.getTemperature());
    }

    public boolean isHighHumidity() {
        return this.biome.isHighHumidity();
    }

    public float getRainfall() {
        return this.biome.getRainfall();
    }

    @Nonnull
    public void findSoundMatches(@Nonnull List<SoundEffect> results) {
        for (int i = 0; i < this.sounds.length; ++i) {
            SoundEffect sound2 = this.sounds[i];
            if (!sound2.matches()) continue;
            results.add(sound2);
        }
    }

    @Nullable
    public SoundEffect getSpotSound(@Nonnull Random random) {
        return this.spotSounds != NO_SOUNDS && random.nextInt(this.spotSoundChance) == 0 ? (SoundEffect)new WeightTable(this.spotSounds).next() : null;
    }

    void resetSounds() {
        this.sounds = NO_SOUNDS;
        this.spotSounds = NO_SOUNDS;
        this.spotSoundChance = 250;
    }

    public boolean isBiomeType(@Nonnull BiomeDictionary.Type type) {
        return this.getBiomeTypes().contains(type);
    }

    public boolean areBiomesSameClass(@Nonnull Biome biome) {
        return BiomeUtils.areBiomesSimilar(this.biome.getBiome(), biome);
    }

    void update(@Nonnull BiomeConfig entry) {
        int[] rgb;
        this.addComment(entry.comment);
        if (entry.hasPrecipitation != null) {
            this.setHasPrecipitation(entry.hasPrecipitation);
        }
        if (entry.hasAurora != null) {
            this.setHasAurora(entry.hasAurora);
        }
        if (entry.hasDust != null) {
            this.setHasDust(entry.hasDust);
        }
        if (entry.hasFog != null) {
            this.setHasFog(entry.hasFog);
        }
        if (entry.fogDensity != null) {
            this.setFogDensity(entry.fogDensity.floatValue());
        }
        if (entry.fogColor != null && (rgb = MyUtils.splitToInts(entry.fogColor, ',')).length == 3) {
            this.setFogColor(new Color(rgb[0], rgb[1], rgb[2]));
        }
        if (entry.dustColor != null && (rgb = MyUtils.splitToInts(entry.dustColor, ',')).length == 3) {
            this.setDustColor(new Color(rgb[0], rgb[1], rgb[2]));
        }
        if (entry.soundReset != null && entry.soundReset.booleanValue()) {
            this.addComment("> Sound Reset");
            this.resetSounds();
        }
        if (entry.spotSoundChance != null) {
            this.setSpotSoundChance(entry.spotSoundChance);
        }
        for (SoundConfig sr : entry.sounds) {
            if (ClientRegistry.SOUND.isSoundBlocked(sr.sound)) continue;
            SoundEffect.Builder b = new SoundEffect.Builder(sr);
            SoundEffect s = b.build();
            if (s.getSoundType() == SoundType.SPOT) {
                this.addSpotSound(s);
                continue;
            }
            this.addSound(s);
        }
    }

    @Nonnull
    public String toString() {
        ResourceLocation rl = this.biome.getKey();
        String registryName = rl == null ? (this.isFake() ? "FAKE" : "UNKNOWN") : rl.toString();
        StringBuilder builder = new StringBuilder();
        builder.append("Biome [").append(this.getBiomeName()).append('/').append(registryName).append("] (").append(this.getBiomeId()).append("):");
        if (!this.isFake()) {
            builder.append("\n+ ").append('<');
            boolean comma = false;
            for (BiomeDictionary.Type t : this.getBiomeTypes()) {
                if (comma) {
                    builder.append(',');
                } else {
                    comma = true;
                }
                builder.append(t.name());
            }
            builder.append('>').append('\n');
            builder.append("+ temp: ").append(this.getTemperature()).append(" (").append(this.getTemperatureRating().getValue()).append(")");
            builder.append(" rain: ").append(this.getRainfall());
        }
        if (this.hasPrecipitation) {
            builder.append(" PRECIPITATION");
        }
        if (this.hasDust) {
            builder.append(" DUST");
        }
        if (this.hasAurora) {
            builder.append(" AURORA");
        }
        if (this.hasFog) {
            builder.append(" FOG");
        }
        if (this.dustColor != null) {
            builder.append(" dustColor:").append(this.dustColor.toString());
        }
        if (this.fogColor != null) {
            builder.append(" fogColor:").append(this.fogColor.toString());
            builder.append(" fogDensity:").append(this.fogDensity);
        }
        if (this.sounds.length > 0) {
            builder.append("\n+ sounds [\n");
            for (SoundEffect sound2 : this.sounds) {
                builder.append("+   ").append(sound2.toString()).append('\n');
            }
            builder.append("+ ]");
        }
        if (this.spotSounds.length > 0) {
            builder.append("\n+ spot sound chance:").append(this.spotSoundChance);
            builder.append("\n+ spot sounds [\n");
            for (SoundEffect sound2 : this.spotSounds) {
                builder.append("+   ").append(sound2.toString()).append('\n');
            }
            builder.append("+ ]");
        }
        if (this.comments.size() > 0) {
            builder.append("\n+ comments:\n");
            for (String c : this.comments) {
                builder.append("+   ").append(c).append('\n');
            }
        }
        return builder.toString();
    }

    @Override
    public int compareTo(@Nonnull BiomeInfo o) {
        return this.getBiomeName().compareTo(o.getBiomeName());
    }

    static {
        if (ModEnvironment.BiomesOPlenty.isLoaded()) {
            try {
                bopBiome = Class.forName("biomesoplenty.common.biome.BOPBiome");
                bopBiomeFogDensity = ReflectionHelper.findField(bopBiome, (String[])new String[]{"fogDensity"});
                bopBiomeFogColor = ReflectionHelper.findField(bopBiome, (String[])new String[]{"fogColor"});
            }
            catch (Throwable t) {
                bopBiome = null;
                bopBiomeFogDensity = null;
                bopBiomeFogColor = null;
            }
        }
        NO_SOUNDS = new SoundEffect[0];
    }
}

