/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import com.google.common.primitives.Booleans;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.data.xface.BiomeConfig;
import org.blockartistry.DynSurround.registry.BiomeInfo;
import org.blockartistry.lib.BiomeUtils;
import org.blockartistry.lib.expression.BooleanValue;
import org.blockartistry.lib.expression.Expression;
import org.blockartistry.lib.expression.Function;
import org.blockartistry.lib.expression.NumberValue;
import org.blockartistry.lib.expression.StringValue;
import org.blockartistry.lib.expression.Variant;

@SideOnly(value=Side.CLIENT)
public abstract class BiomeMatcher {
    public abstract boolean match(@Nonnull BiomeInfo var1);

    public static BiomeMatcher getMatcher(@Nonnull BiomeConfig cfg) {
        if (cfg.conditions == null) {
            cfg.conditions = "";
        }
        return new ConditionsImpl(cfg);
    }

    public static class ConditionsImpl
    extends BiomeMatcher {
        protected BiomeInfo current;
        protected final Expression exp;

        public ConditionsImpl(@Nonnull BiomeConfig config) {
            this.exp = new Expression(config.conditions);
            this.exp.addVariable(new Variant("biome.name"){

                @Override
                public int compareTo(Variant o) {
                    return this.asString().compareTo(o.asString());
                }

                @Override
                public float asNumber() {
                    return 0.0f;
                }

                @Override
                public String asString() {
                    return current.getBiomeName();
                }

                @Override
                public boolean asBoolean() {
                    return false;
                }

                @Override
                public Variant add(Variant term) {
                    return new StringValue(this.asString().concat(term.asString()));
                }
            });
            this.exp.addVariable(new Variant("biome.rainfall"){

                @Override
                public int compareTo(Variant o) {
                    return Float.compare(this.asNumber(), o.asNumber());
                }

                @Override
                public float asNumber() {
                    return current.getRainfall();
                }

                @Override
                public String asString() {
                    return Float.toString(this.asNumber());
                }

                @Override
                public boolean asBoolean() {
                    return this.asNumber() != 0.0f;
                }

                @Override
                public Variant add(Variant term) {
                    return new NumberValue(this.asNumber() + term.asNumber());
                }
            });
            this.exp.addVariable(new Variant("biome.id"){

                @Override
                public int compareTo(Variant o) {
                    return this.asString().compareTo(o.asString());
                }

                @Override
                public float asNumber() {
                    return 0.0f;
                }

                @Override
                public String asString() {
                    return current.getKey().toString();
                }

                @Override
                public boolean asBoolean() {
                    return false;
                }

                @Override
                public Variant add(Variant term) {
                    return new StringValue(this.asString().concat(term.asString()));
                }
            });
            this.exp.addVariable(new Variant("biome.modid"){

                @Override
                public int compareTo(Variant o) {
                    return this.asString().compareTo(o.asString());
                }

                @Override
                public float asNumber() {
                    return 0.0f;
                }

                @Override
                public String asString() {
                    return current.getKey().func_110624_b();
                }

                @Override
                public boolean asBoolean() {
                    return false;
                }

                @Override
                public Variant add(Variant term) {
                    return new StringValue(this.asString().concat(term.asString()));
                }
            });
            this.exp.addVariable(new Variant("biome.isFake"){

                @Override
                public int compareTo(Variant o) {
                    return this.asString().compareTo(o.asString());
                }

                @Override
                public float asNumber() {
                    return this.asBoolean() ? 1.0f : 0.0f;
                }

                @Override
                public String asString() {
                    return Boolean.toString(this.asBoolean());
                }

                @Override
                public boolean asBoolean() {
                    return current.isFake();
                }

                @Override
                public Variant add(Variant term) {
                    return new BooleanValue(this.asBoolean() || term.asBoolean());
                }
            });
            Set<BiomeDictionary.Type> stuff = BiomeUtils.getBiomeTypes();
            for (BiomeDictionary.Type t : stuff) {
                this.exp.addVariable(new BiomeTypeVariable(t));
            }
            for (ResourceLocation b : Biome.field_185377_q.func_148742_b()) {
                if (!"minecraft".equals(b.func_110624_b())) continue;
                this.exp.addVariable(new StringValue("biomeType." + b.func_110623_a(), b.toString()));
            }
            this.exp.addFunction(new Function("biome.isLike", 1){

                @Override
                public Variant eval(Variant ... params) {
                    String biomeName = params[0].asString();
                    Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeName));
                    return biome != null && current.areBiomesSameClass(biome) ? Expression.TRUE : Expression.FALSE;
                }
            });
            this.exp.getRPN();
        }

        @Override
        public boolean match(@Nonnull BiomeInfo info) {
            this.current = info;
            return this.exp.eval().asBoolean();
        }

        private class BiomeTypeVariable
        extends Variant {
            private final BiomeDictionary.Type type;

            public BiomeTypeVariable(BiomeDictionary.Type t) {
                super("biome.is" + t.name());
                this.type = t;
            }

            @Override
            public int compareTo(Variant o) {
                return Booleans.compare((boolean)this.asBoolean(), (boolean)o.asBoolean());
            }

            @Override
            public float asNumber() {
                return this.asBoolean() ? 1.0f : 0.0f;
            }

            @Override
            public String asString() {
                return Boolean.toString(this.asBoolean());
            }

            @Override
            public boolean asBoolean() {
                return ConditionsImpl.this.current.isBiomeType(this.type);
            }

            @Override
            public Variant add(Variant term) {
                return new BooleanValue(this.asBoolean() || term.asBoolean());
            }
        }
    }
}

