/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.fx.BlockEffect;
import org.blockartistry.DynSurround.client.fx.ISpecialEffect;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.registry.BlockInfo;
import org.blockartistry.lib.MyUtils;
import org.blockartistry.lib.WeightTable;

@SideOnly(value=Side.CLIENT)
public class BlockProfile {
    public static final BlockEffect[] NO_EFFECTS = new BlockEffect[0];
    public static final SoundEffect[] NO_SOUNDS = new SoundEffect[0];
    protected final BlockInfo info;
    protected int chance = 100;
    protected int stepChance = 100;
    protected SoundEffect[] sounds = NO_SOUNDS;
    protected SoundEffect[] stepSounds = NO_SOUNDS;
    protected BlockEffect[] effects = NO_EFFECTS;
    protected BlockEffect[] alwaysOn = NO_EFFECTS;

    public static BlockProfile createProfile(@Nonnull BlockInfo blockInfo) {
        return new BlockProfile(blockInfo);
    }

    public BlockProfile(@Nonnull BlockInfo blockInfo) {
        this.info = blockInfo;
    }

    public BlockProfile setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public int getChance() {
        return this.chance;
    }

    public BlockProfile setStepChance(int chance) {
        this.stepChance = chance;
        return this;
    }

    public int getStepChance() {
        return this.stepChance;
    }

    public BlockProfile addSound(@Nonnull SoundEffect sound2) {
        this.sounds = MyUtils.append(this.sounds, sound2);
        return this;
    }

    public BlockProfile clearSounds() {
        this.sounds = NO_SOUNDS;
        return this;
    }

    @Nonnull
    public SoundEffect[] getSounds() {
        return this.sounds;
    }

    public BlockProfile addStepSound(@Nonnull SoundEffect sound2) {
        this.stepSounds = MyUtils.append(this.stepSounds, sound2);
        return this;
    }

    public BlockProfile clearStepSounds() {
        this.stepSounds = NO_SOUNDS;
        return this;
    }

    @Nonnull
    public SoundEffect[] getStepSounds() {
        return this.stepSounds;
    }

    public BlockProfile addEffect(@Nonnull BlockEffect effect) {
        if (effect.getChance() > 0) {
            this.effects = MyUtils.append(this.effects, effect);
        } else {
            this.alwaysOn = MyUtils.append(this.alwaysOn, effect);
        }
        return this;
    }

    public BlockProfile clearEffects() {
        this.effects = NO_EFFECTS;
        this.alwaysOn = NO_EFFECTS;
        return this;
    }

    @Nonnull
    public BlockEffect[] getEffects() {
        return this.effects;
    }

    @Nonnull
    public BlockEffect[] getAlwaysOnEffects() {
        return this.alwaysOn;
    }

    @Nullable
    public SoundEffect getSoundToPlay(@Nonnull Random random) {
        return this.sounds != NO_SOUNDS && random.nextInt(this.getChance()) == 0 ? (SoundEffect)new WeightTable(this.sounds).next() : null;
    }

    @Nullable
    public SoundEffect getStepSoundToPlay(@Nonnull Random random) {
        return this.stepSounds != NO_SOUNDS && random.nextInt(this.getStepChance()) == 0 ? (SoundEffect)new WeightTable(this.stepSounds).next() : null;
    }

    public boolean hasSoundsOrEffects() {
        return this.sounds.length > 0 || this.effects.length > 0;
    }

    public boolean hasAlwaysOnEffects() {
        return this.alwaysOn.length > 0;
    }

    @Nonnull
    public String toString() {
        boolean commaFlag;
        StringBuilder builder = new StringBuilder();
        builder.append("Block [").append(this.info.toString()).append("]");
        if (this.sounds != NO_SOUNDS) {
            commaFlag = false;
            builder.append(" chance:").append(this.chance);
            builder.append("; sounds [");
            for (SoundEffect soundEffect : this.sounds) {
                if (commaFlag) {
                    builder.append(",");
                } else {
                    commaFlag = true;
                }
                builder.append(soundEffect.toString());
            }
            builder.append(']');
        } else {
            builder.append("NO SOUNDS");
        }
        if (this.stepSounds != NO_SOUNDS) {
            commaFlag = false;
            builder.append(" chance:").append(this.stepChance);
            builder.append("; step sounds [");
            for (ISpecialEffect iSpecialEffect : this.stepSounds) {
                if (commaFlag) {
                    builder.append(",");
                } else {
                    commaFlag = true;
                }
                builder.append(((SoundEffect)iSpecialEffect).toString());
            }
            builder.append(']');
        } else {
            builder.append("; NO STEP SOUNDS");
        }
        if (this.effects != this.alwaysOn) {
            commaFlag = false;
            builder.append("; effects [");
            for (ISpecialEffect iSpecialEffect : this.effects) {
                if (commaFlag) {
                    builder.append(",");
                } else {
                    commaFlag = true;
                }
                builder.append(((BlockEffect)iSpecialEffect).toString());
            }
            for (ISpecialEffect iSpecialEffect : this.alwaysOn) {
                if (commaFlag) {
                    builder.append(",");
                } else {
                    commaFlag = true;
                }
                builder.append(((BlockEffect)iSpecialEffect).toString());
            }
            builder.append(']');
        } else {
            builder.append("; NO EFFECTS");
        }
        return builder.toString();
    }
}

