/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.api.effects.BlockEffectType;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.fx.BlockEffect;
import org.blockartistry.DynSurround.client.sound.SoundEffect;
import org.blockartistry.DynSurround.data.xface.BlockConfig;
import org.blockartistry.DynSurround.data.xface.EffectConfig;
import org.blockartistry.DynSurround.data.xface.ModConfigurationFile;
import org.blockartistry.DynSurround.data.xface.SoundConfig;
import org.blockartistry.DynSurround.data.xface.SoundType;
import org.blockartistry.DynSurround.registry.BlockInfo;
import org.blockartistry.DynSurround.registry.BlockProfile;
import org.blockartistry.DynSurround.registry.Registry;
import org.blockartistry.DynSurround.registry.SoundRegistry;

@SideOnly(value=Side.CLIENT)
public final class BlockRegistry
extends Registry {
    private static final BlockProfile NO_PROFILE = BlockProfile.createProfile(new BlockInfo(Blocks.field_150350_a.func_176223_P())).setChance(0).setStepChance(0);
    private Map<BlockInfo, BlockProfile> registry = new HashMap<BlockInfo, BlockProfile>();
    private Map<IBlockState, BlockProfile> cache = new IdentityHashMap<IBlockState, BlockProfile>();
    private final BlockInfo.BlockInfoMutable key = new BlockInfo.BlockInfoMutable();

    public BlockRegistry(@Nonnull Side side) {
        super(side);
    }

    @Override
    public void init() {
        this.registry = new HashMap<BlockInfo, BlockProfile>();
        this.cache = new IdentityHashMap<IBlockState, BlockProfile>();
    }

    @Override
    public void configure(@Nonnull ModConfigurationFile cfg) {
        for (BlockConfig block2 : cfg.blocks) {
            this.register(block2);
        }
    }

    @Override
    public void initComplete() {
        this.registry = ImmutableMap.copyOf(this.registry);
    }

    @Override
    public void fini() {
    }

    @Nonnull
    public BlockProfile findProfile(@Nonnull IBlockState state) {
        BlockProfile profile = this.cache.get(state);
        if (profile == null) {
            profile = this.registry.get(this.key.set(state));
            if (profile == null && this.key.hasSubTypes()) {
                profile = this.registry.get(this.key.asGeneric());
            }
            if (profile == null) {
                profile = NO_PROFILE;
            }
            this.cache.put(state, profile);
        }
        return profile;
    }

    @Nonnull
    public BlockEffect[] getEffects(@Nonnull IBlockState state) {
        return this.findProfile(state).getEffects();
    }

    @Nonnull
    public BlockEffect[] getAlwaysOnEffects(@Nonnull IBlockState state) {
        return this.findProfile(state).getAlwaysOnEffects();
    }

    @Nonnull
    public SoundEffect[] getAllSounds(@Nonnull IBlockState state) {
        return this.findProfile(state).getSounds();
    }

    @Nonnull
    public SoundEffect[] getAllStepSounds(@Nonnull IBlockState state) {
        return this.findProfile(state).getStepSounds();
    }

    public int getStepSoundChance(@Nonnull IBlockState state) {
        return this.findProfile(state).getStepChance();
    }

    public int getSoundChance(@Nonnull IBlockState state) {
        return this.findProfile(state).getChance();
    }

    @Nullable
    public SoundEffect getStepSoundToPlay(@Nonnull IBlockState state, @Nonnull Random rand) {
        return this.findProfile(state).getStepSoundToPlay(rand);
    }

    @Nullable
    public SoundEffect getSoundToPlay(@Nonnull IBlockState state, @Nonnull Random rand) {
        return this.findProfile(state).getSoundToPlay(rand);
    }

    @Nullable
    protected BlockProfile getOrCreateProfile(@Nonnull BlockInfo info) {
        if (info.getBlock() == Blocks.field_150350_a) {
            return null;
        }
        BlockProfile profile = this.registry.get(info);
        if (profile == null) {
            profile = BlockProfile.createProfile(info);
            this.registry.put(info, profile);
        }
        return profile;
    }

    public void register(@Nonnull BlockConfig entry) {
        if (entry.blocks.isEmpty()) {
            return;
        }
        SoundRegistry soundRegistry = ClientRegistry.SOUND;
        for (String blockName : entry.blocks) {
            BlockInfo blockInfo = BlockInfo.create(blockName);
            if (blockInfo == null) {
                DSurround.log().warn("Unknown block [%s] in block config file", blockName);
                continue;
            }
            BlockProfile blockData = this.getOrCreateProfile(blockInfo);
            if (blockData == null) {
                DSurround.log().warn("Unknown block [%s] in block config file", blockName);
                continue;
            }
            if (entry.soundReset != null && entry.soundReset.booleanValue()) {
                blockData.clearSounds();
            }
            if (entry.stepSoundReset != null && entry.stepSoundReset.booleanValue()) {
                blockData.clearStepSounds();
            }
            if (entry.effectReset != null && entry.effectReset.booleanValue()) {
                blockData.clearEffects();
            }
            if (entry.chance != null) {
                blockData.setChance(entry.chance);
            }
            if (entry.stepChance != null) {
                blockData.setStepChance(entry.stepChance);
            }
            for (SoundConfig sr : entry.sounds) {
                SoundEffect eff;
                if (sr.sound == null || soundRegistry.isSoundBlocked(sr.sound)) continue;
                SoundEffect.Builder b = new SoundEffect.Builder(sr);
                if (sr.soundCategory == null) {
                    b.setSoundCategory(SoundCategory.BLOCKS);
                }
                if ((eff = b.build()).getSoundType() == SoundType.STEP) {
                    blockData.addStepSound(eff);
                    continue;
                }
                blockData.addSound(eff);
            }
            for (EffectConfig e : entry.effects) {
                int chance;
                BlockEffect blockEffect;
                if (StringUtils.isEmpty((CharSequence)e.effect)) continue;
                BlockEffectType type = BlockEffectType.get(e.effect);
                if (type == BlockEffectType.UNKNOWN) {
                    DSurround.log().warn("Unknown block effect type in configuration: [%s]", e.effect);
                    continue;
                }
                if (!type.isEnabled() || (blockEffect = type.getInstance(chance = e.chance != null ? e.chance : 100)) == null) continue;
                if (e.conditions != null) {
                    blockEffect.setConditions(e.conditions);
                }
                blockData.addEffect(blockEffect);
            }
        }
    }
}

