/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.data.xface.DimensionConfig;

public final class DimensionInfo {
    public static final DimensionInfo NONE = new DimensionInfo();
    private static final int SPACE_HEIGHT_OFFSET = 32;
    protected final int dimensionId;
    protected final String name;
    protected int seaLevel;
    protected int skyHeight;
    protected int cloudHeight;
    protected int spaceHeight;
    protected boolean hasHaze = false;
    protected boolean hasAuroras = false;
    protected boolean hasWeather = false;
    protected boolean hasFog = false;

    private DimensionInfo() {
        this.dimensionId = Integer.MIN_VALUE;
        this.name = "<NOT SET>";
    }

    public DimensionInfo(@Nonnull World world) {
        this.dimensionId = world.field_73011_w.getDimension();
        this.name = world.field_73011_w.func_186058_p().func_186065_b();
        this.seaLevel = world.func_181545_F();
        this.cloudHeight = this.skyHeight = world.func_72800_K();
        this.spaceHeight = this.skyHeight + 32;
        WorldType wt = world.func_175624_G();
        if (wt == WorldType.field_77138_c) {
            this.seaLevel = 0;
        } else if (this.dimensionId == 0 && ModOptions.biomes.worldSealevelOverride > 0) {
            this.seaLevel = ModOptions.biomes.worldSealevelOverride;
        }
    }

    public DimensionInfo(@Nonnull World world, @Nonnull DimensionConfig entry) {
        this(world);
        if (entry.seaLevel != null) {
            this.seaLevel = entry.seaLevel;
        }
        if (entry.skyHeight != null) {
            this.skyHeight = entry.skyHeight;
        }
        if (entry.hasHaze != null) {
            this.hasHaze = entry.hasHaze;
        }
        if (entry.hasAurora != null) {
            this.hasAuroras = entry.hasAurora;
        }
        if (entry.hasWeather != null) {
            this.hasWeather = entry.hasWeather;
        }
        if (entry.cloudHeight != null) {
            this.cloudHeight = entry.cloudHeight;
        } else {
            int n = this.cloudHeight = this.hasHaze ? this.skyHeight / 2 : this.skyHeight;
        }
        if (entry.hasFog != null) {
            this.hasFog = entry.hasFog;
        }
        this.spaceHeight = this.skyHeight + 32;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public String getName() {
        return this.name;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public int getSkyHeight() {
        return this.skyHeight;
    }

    public int getCloudHeight() {
        return this.cloudHeight;
    }

    public int getSpaceHeight() {
        return this.spaceHeight;
    }

    public boolean getHasHaze() {
        return this.hasHaze;
    }

    public boolean getHasAuroras() {
        return this.hasAuroras;
    }

    public boolean getHasWeather() {
        return this.hasWeather;
    }

    public boolean getHasFog() {
        return this.hasFog;
    }

    @Nonnull
    public String toString() {
        Objects.ToStringHelper builder = Objects.toStringHelper((Object)this);
        builder.add("id", this.dimensionId);
        builder.add("name", (Object)this.name);
        builder.add("seaLevel", this.seaLevel);
        builder.add("cloudHeight", this.cloudHeight);
        builder.add("skyHeight", this.skyHeight);
        builder.add("haze", this.hasHaze);
        builder.add("aurora", this.hasAuroras);
        builder.add("weather", this.hasWeather);
        builder.add("fog", this.hasFog);
        return builder.toString();
    }
}

