/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.data.xface.DimensionConfig;
import org.blockartistry.DynSurround.data.xface.ModConfigurationFile;
import org.blockartistry.DynSurround.registry.DimensionInfo;
import org.blockartistry.DynSurround.registry.Registry;

public final class DimensionRegistry
extends Registry {
    private final List<DimensionConfig> cache = new ArrayList<DimensionConfig>();
    private final TIntObjectHashMap<DimensionInfo> dimensionData = new TIntObjectHashMap();

    public DimensionRegistry(@Nonnull Side side) {
        super(side);
    }

    @Override
    public void init() {
        this.cache.clear();
        this.dimensionData.clear();
    }

    @Override
    public void configure(@Nonnull ModConfigurationFile cfg) {
        cfg.dimensions.forEach(dim -> this.register((DimensionConfig)dim));
    }

    @Override
    public void initComplete() {
        if (ModOptions.logging.enableDebugLogging) {
            DSurround.log().info("*** DIMENSION REGISTRY (cache) ***", new Object[0]);
            this.cache.forEach(dim -> DSurround.log().info(dim.toString(), new Object[0]));
        }
    }

    @Override
    public void fini() {
    }

    public void loading(@Nonnull World world) {
        this.getData(world);
    }

    @Nonnull
    private DimensionConfig getData(@Nonnull DimensionConfig entry) {
        for (DimensionConfig e : this.cache) {
            if (!e.equals(entry)) continue;
            return e;
        }
        this.cache.add(entry);
        return entry;
    }

    public void register(@Nonnull DimensionConfig entry) {
        if (entry.dimensionId != null || entry.name != null) {
            DimensionConfig data = this.getData(entry);
            if (data == entry) {
                return;
            }
            if (data.dimensionId == null) {
                data.dimensionId = entry.dimensionId;
            }
            if (data.name == null) {
                data.name = entry.name;
            }
            if (entry.hasAurora != null) {
                data.hasAurora = entry.hasAurora;
            }
            if (entry.hasHaze != null) {
                data.hasHaze = entry.hasHaze;
            }
            if (entry.hasWeather != null) {
                data.hasWeather = entry.hasWeather;
            }
            if (entry.cloudHeight != null) {
                data.cloudHeight = entry.cloudHeight;
            }
            if (entry.seaLevel != null) {
                data.seaLevel = entry.seaLevel;
            }
            if (entry.skyHeight != null) {
                data.skyHeight = entry.skyHeight;
            }
        }
    }

    @Nonnull
    public DimensionInfo getData(@Nonnull World world) {
        DimensionInfo data = (DimensionInfo)this.dimensionData.get(world.field_73011_w.getDimension());
        if (data == null) {
            DimensionConfig entry = null;
            for (DimensionConfig e : this.cache) {
                if ((e.dimensionId == null || e.dimensionId.intValue() != world.field_73011_w.getDimension()) && (e.name == null || !e.name.equals(world.field_73011_w.func_186058_p().func_186065_b()))) continue;
                entry = e;
                break;
            }
            data = entry == null ? new DimensionInfo(world) : new DimensionInfo(world, entry);
            this.dimensionData.put(world.field_73011_w.getDimension(), (Object)data);
            DSurround.log().info(data.toString(), new Object[0]);
        }
        return data;
    }

    public boolean hasHaze(@Nonnull World world) {
        return this.getData(world).getHasHaze();
    }

    public int getSeaLevel(@Nonnull World world) {
        return this.getData(world).getSeaLevel();
    }

    public int getSkyHeight(@Nonnull World world) {
        return this.getData(world).getSkyHeight();
    }

    public int getCloudHeight(@Nonnull World world) {
        return this.getData(world).getCloudHeight();
    }

    public int getSpaceHeight(@Nonnull World world) {
        return this.getData(world).getSpaceHeight();
    }

    public boolean hasAuroras(@Nonnull World world) {
        return this.getData(world).getHasAuroras();
    }

    public boolean hasWeather(@Nonnull World world) {
        return this.getData(world).getHasWeather();
    }

    public boolean hasFog(@Nonnull World world) {
        return this.getData(world).getHasFog();
    }
}

