/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.footsteps.implem.AcousticsManager;
import org.blockartistry.DynSurround.client.footsteps.implem.BlockMap;
import org.blockartistry.DynSurround.client.footsteps.implem.PrimitiveMap;
import org.blockartistry.DynSurround.client.footsteps.implem.RainSplashAcoustic;
import org.blockartistry.DynSurround.client.footsteps.interfaces.IAcoustic;
import org.blockartistry.DynSurround.client.footsteps.parsers.AcousticsJsonReader;
import org.blockartistry.DynSurround.client.footsteps.system.Generator;
import org.blockartistry.DynSurround.client.footsteps.system.GeneratorQP;
import org.blockartistry.DynSurround.client.footsteps.util.ConfigProperty;
import org.blockartistry.DynSurround.data.xface.ModConfigurationFile;
import org.blockartistry.DynSurround.data.xface.VariatorConfig;
import org.blockartistry.DynSurround.packs.ResourcePacks;
import org.blockartistry.DynSurround.registry.ArmorClass;
import org.blockartistry.DynSurround.registry.BlockInfo;
import org.blockartistry.DynSurround.registry.EntityEffectInfo;
import org.blockartistry.DynSurround.registry.Registry;
import org.blockartistry.DynSurround.registry.Variator;
import org.blockartistry.lib.BlockStateProvider;
import org.blockartistry.lib.ItemStackUtil;
import org.blockartistry.lib.MCHelper;
import org.blockartistry.lib.collections.IdentityHashSet;
import org.blockartistry.lib.logging.ModLog;

@SideOnly(value=Side.CLIENT)
public final class FootstepsRegistry
extends Registry {
    private static final List<String> FOOTPRINT_SOUND_PROFILE = Arrays.asList("minecraft:block.sand.step", "minecraft:block.gravel.step", "minecraft:block.snow.step");
    private AcousticsManager acousticsManager;
    private PrimitiveMap primitiveMap;
    private BlockMap blockMap;
    private Set<Material> FOOTPRINT_MATERIAL;
    private Set<IBlockState> FOOTPRINT_STATES;
    private Map<ArmorClass, IAcoustic> ARMOR_SOUND;
    private Map<ArmorClass, IAcoustic> ARMOR_SOUND_FOOT;
    private Map<String, Variator> variators;
    private Variator childVariator;
    private Variator playerVariator;
    private Variator playerQuadrupedVariator;

    public FootstepsRegistry(@Nonnull Side side) {
        super(side);
    }

    @Override
    public void init() {
        this.acousticsManager = new AcousticsManager();
        this.primitiveMap = new PrimitiveMap(this.acousticsManager);
        this.blockMap = new BlockMap(this.acousticsManager);
        this.FOOTPRINT_MATERIAL = new IdentityHashSet();
        this.FOOTPRINT_STATES = new IdentityHashSet();
        this.ARMOR_SOUND = new EnumMap<ArmorClass, IAcoustic>(ArmorClass.class);
        this.ARMOR_SOUND_FOOT = new EnumMap<ArmorClass, IAcoustic>(ArmorClass.class);
        this.variators = new HashMap<String, Variator>();
        this.FOOTPRINT_MATERIAL.add(Material.field_151571_B);
        this.FOOTPRINT_MATERIAL.add(Material.field_151577_b);
        this.FOOTPRINT_MATERIAL.add(Material.field_151578_c);
        this.FOOTPRINT_MATERIAL.add(Material.field_151588_w);
        this.FOOTPRINT_MATERIAL.add(Material.field_151598_x);
        this.FOOTPRINT_MATERIAL.add(Material.field_151595_p);
        this.FOOTPRINT_MATERIAL.add(Material.field_151596_z);
        this.FOOTPRINT_MATERIAL.add(Material.field_151597_y);
        AcousticsManager.SWIM = null;
        AcousticsManager.JUMP = null;
        AcousticsManager.SPLASH = null;
        List<ResourcePacks.Pack> repo = ResourcePacks.findResourcePacks();
        this.reloadAcoustics(repo);
        this.reloadPrimitiveMap(repo);
        this.seedMap();
    }

    @Override
    public void configure(@Nonnull ModConfigurationFile cfg) {
        for (ModConfigurationFile.ForgeEntry forgeEntry : cfg.forgeMappings) {
            for (String name : forgeEntry.dictionaryEntries) {
                this.registerForgeEntries(forgeEntry.acousticProfile, name);
            }
        }
        for (Map.Entry entry : cfg.footsteps.entrySet()) {
            this.registerBlocks((String)entry.getValue(), (String)entry.getKey());
        }
        for (String string : cfg.footprints) {
            this.registerFootrint(string);
        }
        for (Map.Entry entry : cfg.variators.entrySet()) {
            this.variators.put((String)entry.getKey(), new Variator((VariatorConfig)entry.getValue()));
        }
    }

    @Override
    public void initComplete() {
        this.getBlockMap().freeze();
        AcousticsManager.SWIM = this.acousticsManager.compileAcoustics("_SWIM");
        AcousticsManager.JUMP = this.acousticsManager.compileAcoustics("_JUMP");
        AcousticsManager.SPLASH = new IAcoustic[]{new RainSplashAcoustic(this.acousticsManager.compileAcoustics("waterfine"))};
        AcousticsManager am = this.acousticsManager;
        this.ARMOR_SOUND.put(ArmorClass.NONE, am.getAcoustic("NOT_EMITTER"));
        this.ARMOR_SOUND.put(ArmorClass.LIGHT, am.getAcoustic("armor_light"));
        this.ARMOR_SOUND.put(ArmorClass.MEDIUM, am.getAcoustic("armor_medium"));
        this.ARMOR_SOUND.put(ArmorClass.CRYSTAL, am.getAcoustic("armor_crystal"));
        this.ARMOR_SOUND.put(ArmorClass.HEAVY, am.getAcoustic("armor_heavy"));
        this.ARMOR_SOUND_FOOT.put(ArmorClass.NONE, am.getAcoustic("NOT_EMITTER"));
        this.ARMOR_SOUND_FOOT.put(ArmorClass.LIGHT, am.getAcoustic("armor_light"));
        this.ARMOR_SOUND_FOOT.put(ArmorClass.MEDIUM, am.getAcoustic("medium_foot"));
        this.ARMOR_SOUND_FOOT.put(ArmorClass.CRYSTAL, am.getAcoustic("crystal_foot"));
        this.ARMOR_SOUND_FOOT.put(ArmorClass.HEAVY, am.getAcoustic("heavy_foot"));
        this.childVariator = this.getVariator("child");
        this.playerVariator = this.getVariator(ModOptions.sound.firstPersonFootstepCadence ? "playerSlow" : "player");
        this.playerQuadrupedVariator = this.getVariator(ModOptions.sound.firstPersonFootstepCadence ? "quadrupedSlow" : "quadruped");
        Set blockStates = StreamSupport.stream(ForgeRegistries.BLOCKS.spliterator(), false).map(block2 -> block2.func_176194_O().func_177619_a()).flatMap(l -> l.stream()).collect(Collectors.toSet());
        Set missingAcoustics = blockStates.stream().filter(bs -> !this.getBlockMap().hasAcoustics((IBlockState)bs)).collect(Collectors.toSet());
        if (ModOptions.logging.enableDebugLogging && missingAcoustics.size() > 0) {
            DSurround.log().info("          >>>> MISSING ACOUSTIC ENTRIES <<<< ", new Object[0]);
            DSurround.log().info("Sounds for these states will default to their step sound", new Object[0]);
            DSurround.log().info("========================================================", new Object[0]);
            missingAcoustics.stream().map(Object::toString).sorted().forEach(arg_0 -> FootstepsRegistry.lambda$initComplete$3(DSurround.log(), arg_0));
        }
        blockStates.stream().filter(bs -> bs.func_185904_a().func_76230_c() && !this.FOOTPRINT_MATERIAL.contains(bs.func_185904_a()) && !this.FOOTPRINT_STATES.contains(bs)).filter(bs -> {
            ResourceLocation resource;
            SoundEvent event;
            SoundType sound2 = MCHelper.getSoundType(bs);
            if (sound2 != null && (event = sound2.func_185844_d()) != null && (resource = event.func_187503_a()) != null) {
                String soundName = resource.toString();
                return FOOTPRINT_SOUND_PROFILE.contains(soundName);
            }
            return false;
        }).forEach(bs -> this.FOOTPRINT_STATES.add((IBlockState)bs));
    }

    @Override
    public void fini() {
    }

    private void reloadPrimitiveMap(@Nonnull List<ResourcePacks.Pack> repo) {
        for (ResourcePacks.Pack pack : repo) {
            try {
                InputStream stream = pack.getInputStream(ResourcePacks.PRIMITIVEMAP_RESOURCE);
                Throwable throwable = null;
                try {
                    if (stream == null) continue;
                    this.primitiveMap.setup(ConfigProperty.fromStream(stream));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                DSurround.log().debug("Unable to load primitive map data from pack %s", pack.getModName());
            }
        }
    }

    private void reloadAcoustics(@Nonnull List<ResourcePacks.Pack> repo) {
        for (ResourcePacks.Pack pack : repo) {
            try {
                InputStream stream = pack.getInputStream(ResourcePacks.ACOUSTICS_RESOURCE);
                Throwable throwable = null;
                try {
                    if (stream == null) continue;
                    Scanner scanner = new Scanner(stream);
                    Throwable throwable2 = null;
                    try {
                        String jasonString = scanner.useDelimiter("\\Z").next();
                        new AcousticsJsonReader("").parseJSON(jasonString, this.acousticsManager);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (scanner == null) continue;
                        if (throwable2 != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        scanner.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                DSurround.log().debug("Unable to load acoustic data from pack %s", pack.getModName());
            }
        }
    }

    private void seedMap() {
        for (Block block2 : Block.field_149771_c) {
            String blockName = MCHelper.nameOf(block2);
            if (block2 instanceof BlockCrops) {
                BlockCrops crop = (BlockCrops)block2;
                if (crop.func_185526_g() == 3) {
                    this.registerBlocks("#beets", blockName);
                    continue;
                }
                if (blockName.equals("minecraft:wheat")) {
                    this.registerBlocks("#wheat", blockName);
                    continue;
                }
                if (crop.func_185526_g() != 7) continue;
                this.registerBlocks("#crop", blockName);
                continue;
            }
            if (block2 instanceof BlockSapling) {
                this.registerBlocks("#sapling", blockName);
                continue;
            }
            if (block2 instanceof BlockReed) {
                this.registerBlocks("#reed", blockName);
                continue;
            }
            if (block2 instanceof BlockFence) {
                this.registerBlocks("#fence", blockName);
                continue;
            }
            if (block2 instanceof BlockFlower || block2 instanceof BlockMushroom) {
                this.registerBlocks("NOT_EMITTER", blockName);
                continue;
            }
            if (block2 instanceof BlockLog || block2 instanceof BlockPlanks) {
                this.registerBlocks("wood", blockName);
                continue;
            }
            if (block2 instanceof BlockDoor) {
                this.registerBlocks("bluntwood", blockName);
                continue;
            }
            if (block2 instanceof BlockLeaves) {
                this.registerBlocks("leaves", blockName);
                continue;
            }
            if (block2 instanceof BlockOre) {
                this.registerBlocks("ore", blockName);
                continue;
            }
            if (!(block2 instanceof BlockIce)) continue;
            this.registerBlocks("ice", blockName);
        }
    }

    public Generator createGenerator(@Nonnull EntityLivingBase entity) {
        EntityEffectInfo info = ClientRegistry.EFFECTS.getEffects((Entity)entity);
        Variator var = this.getVariator(info.variator);
        if (entity.func_70631_g_()) {
            var = this.childVariator;
        } else if (entity instanceof EntityPlayer) {
            var = ModOptions.sound.foostepsQuadruped ? this.playerQuadrupedVariator : this.playerVariator;
        }
        return var.QUADRUPED ? new GeneratorQP(var) : new Generator(var);
    }

    @Nonnull
    public Variator getVariator(@Nonnull String varName) {
        return this.variators.getOrDefault(varName, Variator.DEFAULT);
    }

    @Nonnull
    public BlockMap getBlockMap() {
        return this.blockMap;
    }

    @Nullable
    public IAcoustic[] resolvePrimitive(@Nonnull IBlockState state) {
        String soundName;
        if (state == BlockStateProvider.AIR_STATE) {
            return AcousticsManager.NOT_EMITTER;
        }
        SoundType type = MCHelper.getSoundType(state);
        if (type == null) {
            return AcousticsManager.NOT_EMITTER;
        }
        boolean flag = false;
        if (type.func_185844_d() == null || type.func_185844_d().func_187503_a().func_110623_a().isEmpty()) {
            soundName = "UNDEFINED";
            flag = true;
        } else {
            soundName = type.func_185844_d().func_187503_a().toString();
        }
        String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(type.func_185843_a()), Float.valueOf(type.func_185847_b()));
        IAcoustic[] primitive = this.primitiveMap.getPrimitiveMapSubstrate(soundName, substrate);
        if (primitive == null) {
            if (flag) {
                primitive = this.primitiveMap.getPrimitiveMapSubstrate(soundName, "break_" + soundName);
            }
            if (primitive == null) {
                primitive = this.primitiveMap.getPrimitiveMap(soundName);
            }
        }
        if (primitive == null) {
            // empty if block
        }
        return primitive;
    }

    public boolean hasFootprint(@Nonnull IBlockState state) {
        return this.FOOTPRINT_MATERIAL.contains(state.func_185904_a()) || this.FOOTPRINT_STATES.contains(state);
    }

    @Nullable
    public IAcoustic getArmorAcoustic(@Nonnull ArmorClass ac) {
        return ac != null ? this.ARMOR_SOUND.get((Object)ac) : null;
    }

    @Nullable
    public IAcoustic getFootArmorAcoustic(@Nonnull ArmorClass ac) {
        return ac != null ? this.ARMOR_SOUND_FOOT.get((Object)ac) : null;
    }

    private static Block resolveToBlock(@Nonnull ItemStack stack) {
        if (!ItemStackUtil.isValidItemStack(stack)) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).func_179223_d();
        }
        if (item instanceof ItemBlockSpecial) {
            return ((ItemBlockSpecial)item).getBlock();
        }
        return null;
    }

    public void registerFootrint(String ... blocks) {
        for (String b : blocks) {
            IBlockState state;
            boolean materialMatch = false;
            if (b.startsWith("@")) {
                materialMatch = true;
                b = b.substring(1);
            }
            BlockInfo bi = BlockInfo.create(b);
            if (materialMatch) {
                state = bi.getBlock().func_176223_P();
                this.FOOTPRINT_MATERIAL.add(state.func_185904_a());
                continue;
            }
            if (!bi.isGeneric()) {
                state = bi.getBlock().func_176223_P();
                this.FOOTPRINT_STATES.add(state);
                continue;
            }
            DSurround.log().warn("Generic matching is not supported for footprints: %s", b);
        }
    }

    public void registerForgeEntries(@Nonnull String blockClass, String ... entries) {
        for (String dictionaryName : entries) {
            List stacks = OreDictionary.getOres((String)dictionaryName, (boolean)false);
            for (ItemStack stack : stacks) {
                Block block2 = FootstepsRegistry.resolveToBlock(stack);
                if (block2 == null) continue;
                String blockName = MCHelper.nameOf(block2);
                if (stack.func_77981_g() && stack.func_77952_i() != Short.MAX_VALUE) {
                    blockName = blockName + "^" + stack.func_77952_i();
                }
                this.getBlockMap().register(blockName, blockClass);
            }
        }
    }

    public void registerBlocks(@Nonnull String blockClass, String ... blocks) {
        for (String s : blocks) {
            this.getBlockMap().register(s, blockClass);
        }
    }

    private static /* synthetic */ void lambda$initComplete$3(ModLog rec$, String x$0) {
        rec$.info(x$0, new Object[0]);
    }
}

