/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.data.Profiles;
import org.blockartistry.DynSurround.data.xface.DataScripts;
import org.blockartistry.DynSurround.data.xface.ModConfigurationFile;
import org.blockartistry.DynSurround.event.ReloadEvent;
import org.blockartistry.DynSurround.packs.ResourcePacks;
import org.blockartistry.DynSurround.registry.Registry;
import org.blockartistry.lib.SideLocal;
import org.blockartistry.lib.logging.ModLog;
import org.blockartistry.lib.task.Scheduler;

public final class RegistryManager {
    private static final SideLocal<RegistryManager> managers = new SideLocal<RegistryManager>(){

        @Override
        protected RegistryManager initialValue(@Nonnull Side side) {
            return new RegistryManager(side);
        }
    };
    protected final Side side;
    protected final Map<Class<? extends Registry>, Registry> registries = new IdentityHashMap<Class<? extends Registry>, Registry>();
    protected final List<Registry> initOrder = new ArrayList<Registry>();
    protected boolean initialized;

    @Nonnull
    public static RegistryManager get() {
        return managers.get();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onReload(@Nonnull ReloadEvent.Resources event) {
        RegistryManager.reloadResources(Side.CLIENT);
    }

    @SubscribeEvent
    public static void onReload(@Nonnull ReloadEvent.Configuration event) {
        if (event.side == null || event.side == Side.CLIENT) {
            RegistryManager.reloadResources(Side.CLIENT);
        }
        if (event.side == null || event.side == Side.SERVER) {
            RegistryManager.reloadResources(Side.SERVER);
        }
    }

    public static void reloadResources(@Nonnull Side side) {
        if (managers.hasValue(side)) {
            Scheduler.schedule(side, () -> managers.get().reload());
        }
    }

    RegistryManager(Side side) {
        this.side = side;
    }

    public <T> T get(@Nonnull Class<? extends Registry> reg) {
        Registry o = this.registries.get(reg);
        if (o == null) {
            throw new RuntimeException("Attempt to get a registry that has not been configured [" + reg.getName() + "]");
        }
        return (T)this.registries.get(reg);
    }

    public void register(@Nonnull Registry reg) {
        this.registries.put(reg.getClass(), reg);
        this.initOrder.add(reg);
    }

    protected void configRegistries(@Nonnull ModConfigurationFile cfg, @Nonnull String txt) {
        if (cfg != null) {
            DSurround.log().info("Loading %s", txt);
            this.initOrder.forEach(reg -> {
                try {
                    reg.configure(cfg);
                }
                catch (Throwable t) {
                    String temp = String.format("[%s] had issues loading %s!", reg.getClass().getSimpleName(), txt);
                    DSurround.log().error(temp, t);
                }
            });
        }
    }

    protected void process(@Nonnull ResourcePacks.Pack p, @Nonnull ResourceLocation rl, @Nonnull String txt) {
        block26: {
            try (InputStream stream = p.getInputStream(rl);){
                if (stream == null) break block26;
                try (InputStreamReader reader = new InputStreamReader(stream);){
                    ModConfigurationFile cfg = DataScripts.loadFromStream(reader);
                    this.configRegistries(cfg, txt);
                }
            }
            catch (Throwable t) {
                String temp = String.format("Error loading %s", txt);
                DSurround.log().error(temp, t);
            }
        }
    }

    public void reload() {
        List<ResourcePacks.Pack> packs = ResourcePacks.findResourcePacks();
        List activeMods = Loader.instance().getActiveModList();
        DSurround.log().info("Identified the following resource pack locations", new Object[0]);
        packs.stream().map(ResourcePacks.Pack::toString).forEach(arg_0 -> RegistryManager.lambda$reload$2(DSurround.log(), arg_0));
        this.initOrder.forEach(Registry::init);
        activeMods.stream().map(mod -> new ResourceLocation("dsurround", "data/" + mod.getModId().toLowerCase() + ".json")).forEach(rl -> packs.forEach(p -> {
            String loadingText = "[" + rl.toString() + "] <- [" + p.getModName() + "]";
            this.process((ResourcePacks.Pack)p, (ResourceLocation)rl, loadingText);
        }));
        ResourceLocation rl2 = ResourcePacks.CONFIGURE_RESOURCE;
        packs.stream().forEach(p -> this.process((ResourcePacks.Pack)p, rl2, "[" + rl2.toString() + "] <- [" + p.getModName() + "]"));
        List<Profiles.ProfileScript> resources = Profiles.getProfileStreams();
        for (Profiles.ProfileScript script : resources) {
            try {
                InputStreamReader reader = new InputStreamReader(script.stream);
                Throwable throwable = null;
                try {
                    ModConfigurationFile cfg2 = DataScripts.loadFromStream(reader);
                    String loadingText = "[dsurround] <- [" + script.packName + "]";
                    this.configRegistries(cfg2, loadingText);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (Throwable ex) {
                String temp = String.format("Unable to load profile [%s]", script.packName);
                DSurround.log().error(temp, ex);
            }
        }
        Arrays.stream(ModOptions.general.externalScriptFiles).forEach(cfg -> this.configRegistries(DataScripts.loadFromDirectory(cfg), "[" + cfg + "]"));
        this.initOrder.forEach(Registry::initComplete);
        MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent.Registry(this.side));
    }

    private static /* synthetic */ void lambda$reload$2(ModLog rec$, String x$0) {
        rec$.info(x$0, new Object[0]);
    }
}

