/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import gnu.trove.map.hash.TIntObjectHashMap;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.data.xface.ModConfigurationFile;
import org.blockartistry.DynSurround.registry.Registry;
import org.blockartistry.DynSurround.registry.SeasonType;
import org.blockartistry.DynSurround.registry.TemperatureRating;
import org.blockartistry.DynSurround.registry.season.SeasonInfo;
import org.blockartistry.DynSurround.registry.season.SeasonInfoNether;
import org.blockartistry.DynSurround.registry.season.SeasonInfoToughAsNails;
import org.blockartistry.lib.compat.ModEnvironment;

@SideOnly(value=Side.CLIENT)
public final class SeasonRegistry
extends Registry {
    private final TIntObjectHashMap<SeasonInfo> seasonData = new TIntObjectHashMap();

    public SeasonRegistry(@Nonnull Side side) {
        super(side);
    }

    @Override
    public void configure(@Nonnull ModConfigurationFile cfg) {
    }

    protected SeasonInfo factory(@Nonnull World world) {
        if (world.field_73011_w.getDimension() == -1) {
            DSurround.log().info("Creating Nether SeasonInfo", new Object[0]);
            return new SeasonInfoNether(world);
        }
        if (ModEnvironment.ToughAsNails.isLoaded()) {
            DSurround.log().info("Creating Tough as Nails SeasonInfo for dimension %s", world.field_73011_w.func_186058_p().func_186065_b());
            return new SeasonInfoToughAsNails(world);
        }
        DSurround.log().info("Creating default SeasonInfo for dimension %s", world.field_73011_w.func_186058_p().func_186065_b());
        return new SeasonInfo(world);
    }

    @Nonnull
    protected SeasonInfo getData(@Nonnull World world) {
        SeasonInfo result = (SeasonInfo)this.seasonData.get(world.field_73011_w.getDimension());
        if (result == null) {
            result = this.factory(world);
            this.seasonData.put(world.field_73011_w.getDimension(), (Object)result);
        }
        return result;
    }

    @Nonnull
    public TemperatureRating getPlayerTemperature(@Nonnull World world) {
        return this.getData(world).getPlayerTemperature(world);
    }

    @Nonnull
    public TemperatureRating getBiomeTemperature(@Nonnull World world, @Nonnull BlockPos pos) {
        return this.getData(world).getBiomeTemperature(world, pos);
    }

    @Nonnull
    public SeasonType getSeasonType(@Nonnull World world) {
        return this.getData(world).getSeasonType(world);
    }

    @Nonnull
    public String getSeasonName(@Nonnull World world) {
        return this.getData(world).getSeasonName(world);
    }

    @Nonnull
    public BlockPos getPrecipitationHeight(@Nonnull World world, @Nonnull BlockPos pos) {
        return this.getData(world).getPrecipitationHeight(world, pos);
    }

    public float getTemperature(@Nonnull World world, @Nonnull BlockPos pos) {
        return this.getData(world).getTemperature(world, pos);
    }

    public boolean canWaterFreeze(@Nonnull World world, @Nonnull BlockPos pos) {
        return this.getData(world).canWaterFreeze(world, pos);
    }

    public boolean canSnowAt(@Nonnull World world, @Nonnull BlockPos pos) {
        return this.getData(world).canSnowAt(world, pos);
    }

    public boolean canBlockFreeze(@Nonnull World world, @Nonnull BlockPos pos, boolean noWaterAdjacent) {
        return this.getData(world).canBlockFreeze(world, pos, noWaterAdjacent);
    }
}

