/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry;

import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.DynSurround.DSurround;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.client.gui.ConfigSound;
import org.blockartistry.DynSurround.client.sound.Sounds;
import org.blockartistry.DynSurround.data.xface.ModConfigurationFile;
import org.blockartistry.DynSurround.registry.Registry;
import org.blockartistry.DynSurround.registry.SoundMetadata;
import org.blockartistry.lib.MyUtils;
import org.blockartistry.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public final class SoundRegistry
extends Registry {
    public static final float MIN_SOUNDFACTOR = 0.0f;
    public static final float MAX_SOUNDFACTOR = 4.0f;
    public static final float DEFAULT_SOUNDFACTOR = 1.0f;
    private static final String ARMOR_SOUND_PREFIX = "dsurround:fs.armor.";
    private final List<String> cullSoundNames = new ArrayList<String>();
    private final List<String> blockSoundNames = new ArrayList<String>();
    private final TObjectFloatHashMap<String> volumeControl = new TObjectFloatHashMap(10, 0.5f, 1.0f);

    public SoundRegistry(@Nonnull Side side) {
        super(side);
    }

    @Override
    public void init() {
        this.cullSoundNames.clear();
        this.blockSoundNames.clear();
        this.volumeControl.clear();
        MyUtils.addAll(this.cullSoundNames, ModOptions.sound.culledSounds);
        MyUtils.addAll(this.blockSoundNames, ModOptions.sound.blockedSounds);
        for (String volume : ModOptions.sound.soundVolumes) {
            String[] tokens = StringUtils.split((String)volume, (String)"=");
            if (tokens.length != 2) continue;
            try {
                float vol = (float)Integer.parseInt(tokens[1]) / 100.0f;
                this.volumeControl.put((Object)tokens[0], MathStuff.clamp(vol, 0.0f, 4.0f));
            }
            catch (Throwable t) {
                DSurround.log().error("Unable to process sound volume entry: " + volume, t);
            }
        }
    }

    @Override
    public void configure(@Nonnull ModConfigurationFile cfg) {
    }

    @Override
    public void fini() {
    }

    public boolean isSoundCulled(@Nonnull String sound2) {
        return this.cullSoundNames.contains(sound2);
    }

    public boolean isSoundBlocked(@Nonnull String sound2) {
        return this.blockSoundNames.contains(sound2);
    }

    public boolean isSoundBlockedLogical(@Nonnull String sound2) {
        return this.isSoundBlocked(sound2) || !ModOptions.sound.enableArmorSounds && sound2.startsWith(ARMOR_SOUND_PREFIX);
    }

    public float getVolumeScale(@Nonnull String soundName) {
        return this.volumeControl.get((Object)soundName);
    }

    public float getVolumeScale(@Nonnull ISound sound2) {
        return sound2.func_147650_b() == null || sound2 instanceof ConfigSound ? 1.0f : this.volumeControl.get((Object)sound2.func_147650_b().toString());
    }

    @Nullable
    public SoundMetadata getSoundMetadata(@Nonnull ResourceLocation resource) {
        return Sounds.getSoundMetadata(resource);
    }
}

