/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry.season;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.ClientRegistry;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.registry.SeasonType;
import org.blockartistry.DynSurround.registry.TemperatureRating;

@SideOnly(value=Side.CLIENT)
public class SeasonInfo {
    protected final String dimensionName;

    public SeasonInfo(@Nonnull World world) {
        this.dimensionName = world.field_73011_w.func_186058_p().func_186065_b();
    }

    @Nonnull
    public SeasonType getSeasonType(@Nonnull World world) {
        return SeasonType.NONE;
    }

    @Nonnull
    public String getSeasonName(@Nonnull World world) {
        return this.getSeasonType(world).getValue();
    }

    @Nonnull
    public TemperatureRating getPlayerTemperature(@Nonnull World world) {
        return this.getBiomeTemperature(world, EnvironStateHandler.EnvironState.getPlayerPosition());
    }

    @Nonnull
    public TemperatureRating getBiomeTemperature(@Nonnull World world, @Nonnull BlockPos pos) {
        return TemperatureRating.fromTemp(this.getTemperature(world, pos));
    }

    @Nonnull
    public BlockPos getPrecipitationHeight(@Nonnull World world, @Nonnull BlockPos pos) {
        return world.func_175725_q(pos);
    }

    public float getTemperature(@Nonnull World world, @Nonnull BlockPos pos) {
        float biomeTemp = ClientRegistry.BIOME.get(world.func_180494_b(pos)).getFloatTemperature(pos);
        float heightTemp = world.func_72959_q().func_76939_a(biomeTemp, this.getPrecipitationHeight(world, pos).func_177956_o());
        return heightTemp;
    }

    public boolean isRainingAt(@Nonnull World world, @Nonnull BlockPos pos) {
        return world.func_175727_C(pos);
    }

    public boolean canWaterFreeze(@Nonnull World world, @Nonnull BlockPos pos) {
        return this.getTemperature(world, pos) < 0.15f;
    }

    public boolean canSnowAt(@Nonnull World world, @Nonnull BlockPos pos) {
        return world.func_175708_f(pos, false);
    }

    public boolean canBlockFreeze(@Nonnull World world, @Nonnull BlockPos pos, boolean noWaterAdjacent) {
        return world.func_175670_e(pos, noWaterAdjacent);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.dimensionName).toString();
    }
}

