/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.registry.season;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.DynSurround.client.handlers.EnvironStateHandler;
import org.blockartistry.DynSurround.registry.SeasonType;
import org.blockartistry.DynSurround.registry.TemperatureRating;
import org.blockartistry.DynSurround.registry.season.SeasonInfo;
import toughasnails.api.season.Season;
import toughasnails.api.season.SeasonHelper;
import toughasnails.api.season.WorldHooks;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;

@SideOnly(value=Side.CLIENT)
public class SeasonInfoToughAsNails
extends SeasonInfo {
    public SeasonInfoToughAsNails(@Nonnull World world) {
        super(world);
    }

    @Override
    @Nonnull
    public SeasonType getSeasonType(@Nonnull World world) {
        Season.SubSeason season = SeasonHelper.getSeasonData((World)world).getSubSeason();
        switch (season) {
            case EARLY_SUMMER: 
            case MID_SUMMER: 
            case LATE_SUMMER: {
                return SeasonType.SUMMER;
            }
            case EARLY_AUTUMN: 
            case MID_AUTUMN: 
            case LATE_AUTUMN: {
                return SeasonType.AUTUMN;
            }
            case EARLY_WINTER: 
            case MID_WINTER: 
            case LATE_WINTER: {
                return SeasonType.WINTER;
            }
            case EARLY_SPRING: 
            case MID_SPRING: 
            case LATE_SPRING: {
                return SeasonType.SPRING;
            }
        }
        return SeasonType.NONE;
    }

    private Season getSeasonData(@Nonnull World world) {
        return SeasonHelper.getSeasonData((World)world).getSubSeason().getSeason();
    }

    @Override
    public float getTemperature(@Nonnull World world, @Nonnull BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        if (biome.func_185353_n() <= 0.7f && this.getSeasonData(world) == Season.WINTER) {
            return 0.0f;
        }
        return biome.func_180626_a(pos);
    }

    @Override
    @Nonnull
    public TemperatureRating getPlayerTemperature(@Nonnull World world) {
        ITemperature data = TemperatureHelper.getTemperatureData((EntityPlayer)EnvironStateHandler.EnvironState.getPlayer());
        if (data == null) {
            return super.getPlayerTemperature(world);
        }
        switch (data.getTemperature().getRange()) {
            case ICY: {
                return TemperatureRating.ICY;
            }
            case COOL: {
                return TemperatureRating.COOL;
            }
            case MILD: {
                return TemperatureRating.MILD;
            }
            case WARM: {
                return TemperatureRating.WARM;
            }
            case HOT: {
                return TemperatureRating.HOT;
            }
        }
        return TemperatureRating.MILD;
    }

    @Override
    public boolean isRainingAt(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldHooks.isRainingAtInSeason((World)world, (BlockPos)pos, (Season)this.getSeasonData(world));
    }

    @Override
    public boolean canWaterFreeze(@Nonnull World world, @Nonnull BlockPos pos) {
        return this.getTemperature(world, pos) < 0.15f;
    }

    @Override
    public boolean canSnowAt(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldHooks.canSnowAtInSeason((World)world, (BlockPos)pos, (boolean)true, (Season)this.getSeasonData(world));
    }

    @Override
    public boolean canBlockFreeze(@Nonnull World world, @Nonnull BlockPos pos, boolean noWaterAdjacent) {
        return WorldHooks.canBlockFreezeInSeason((World)world, (BlockPos)pos, (boolean)noWaterAdjacent, (Season)this.getSeasonData(world));
    }
}

