/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.DynSurround.server.services;

import gnu.trove.map.hash.TIntDoubleHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.blockartistry.DynSurround.ModOptions;
import org.blockartistry.DynSurround.network.Network;
import org.blockartistry.DynSurround.network.PacketServerData;
import org.blockartistry.DynSurround.server.services.AtmosphereService;
import org.blockartistry.DynSurround.server.services.EntityEmojiService;
import org.blockartistry.DynSurround.server.services.EnvironmentService;
import org.blockartistry.DynSurround.server.services.ServerRegistry;
import org.blockartistry.DynSurround.server.services.Service;
import org.blockartistry.DynSurround.server.services.SpeechBubbleService;

public final class ServiceManager
extends Service {
    private static final ServiceManager INSTANCE = new ServiceManager();
    private final List<Service> services = new ArrayList<Service>();
    private static long tpsCount = 0L;

    private ServiceManager() {
        super("ServiceManager");
    }

    private void addService(Service service) {
        this.services.add(service);
    }

    private void clearServices() {
        this.services.clear();
    }

    private void init0() {
        for (Service s : this.services) {
            s.init();
            MinecraftForge.EVENT_BUS.register((Object)s);
        }
    }

    private void fini0() {
        for (Service s : this.services) {
            s.fini();
            MinecraftForge.EVENT_BUS.unregister((Object)s);
        }
    }

    public static void initialize() {
        INSTANCE.addService(INSTANCE);
        INSTANCE.addService(new AtmosphereService());
        INSTANCE.addService(new EntityEmojiService());
        INSTANCE.addService(new SpeechBubbleService());
        INSTANCE.addService(new EnvironmentService());
        INSTANCE.init0();
    }

    public static void deinitialize() {
        INSTANCE.fini0();
        INSTANCE.clearServices();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load e) {
        ServerRegistry.DIMENSION.loading(e.getWorld());
    }

    private static long mean(@Nonnull long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    @SubscribeEvent
    public void tickEvent(@Nonnull TickEvent.ServerTickEvent event) {
        if (!ModOptions.logging.reportServerStats || event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tpsCount % 20L != 0L) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        TIntDoubleHashMap map = new TIntDoubleHashMap();
        for (Integer dim : DimensionManager.getIDs()) {
            map.put(dim.intValue(), (double)ServiceManager.mean((long[])server.worldTickTimes.get(dim)) / 1000000.0);
        }
        double meanTickTime = (double)ServiceManager.mean(server.field_71311_j) / 1000000.0;
        int total = (int)(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        int max = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        int free = (int)(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        PacketServerData packet = new PacketServerData(map, meanTickTime, free, total, max);
        Network.sendToAll(packet);
    }
}

