/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.Presets.api;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.blockartistry.Presets.api.PresetData;
import org.blockartistry.Presets.api.Utils;

public class ConfigurationHelper {
    protected static final IConfigFilter DEFAULT_FILTER = new IConfigFilter(){

        @Override
        public boolean skipCategory(@Nonnull ConfigCategory category) {
            return false;
        }

        @Override
        public boolean skipProperty(@Nonnull ConfigCategory category, @Nonnull Property property) {
            return false;
        }
    };
    protected final PresetData data;

    public ConfigurationHelper(@Nonnull PresetData data) {
        this.data = data;
    }

    @Nonnull
    public ConfigurationHelper save(@Nonnull ConfigCategory category, @Nonnull Property prop) {
        if (category.requiresMcRestart() || category.requiresWorldRestart()) {
            this.data.restartRequired();
        }
        return this.save(category.getQualifiedName(), prop);
    }

    @Nonnull
    public ConfigurationHelper save(@Nonnull String category, @Nonnull Property prop) {
        if (prop.requiresMcRestart() || prop.requiresWorldRestart()) {
            this.data.restartRequired();
        }
        String id = category + "." + prop.getName();
        switch (prop.getType()) {
            case STRING: {
                if (prop.isList()) {
                    this.data.setStringList(id, prop.getStringList(), '\n');
                    break;
                }
                this.data.setString(id, prop.getString());
                break;
            }
            case INTEGER: {
                if (prop.isList()) {
                    this.data.setIntList(id, prop.getIntList());
                    break;
                }
                this.data.setInt(id, prop.getInt());
                break;
            }
            case BOOLEAN: {
                if (prop.isList()) {
                    this.data.setBooleanList(id, prop.getBooleanList());
                    break;
                }
                this.data.setBoolean(id, prop.getBoolean());
                break;
            }
            case DOUBLE: {
                if (prop.isList()) {
                    this.data.setDoubleList(id, prop.getDoubleList());
                    break;
                }
                this.data.setDouble(id, prop.getDouble());
                break;
            }
        }
        return this;
    }

    @Nonnull
    public ConfigurationHelper load(@Nonnull ConfigCategory category, @Nonnull Property prop) {
        return this.load(category.getQualifiedName(), prop);
    }

    @Nonnull
    public ConfigurationHelper load(@Nonnull String category, @Nonnull Property prop) {
        String id = category + "." + prop.getName();
        switch (prop.getType()) {
            case STRING: {
                if (prop.isList()) {
                    prop.set(this.data.getStringList(id, prop.getDefaults(), '\n'));
                    break;
                }
                prop.set(this.data.getString(id, prop.getDefault()));
                break;
            }
            case INTEGER: {
                if (prop.isList()) {
                    prop.set(this.data.getIntList(id, Utils.toIntArray(prop.getDefaults())));
                    break;
                }
                prop.set(this.data.getInt(id, Integer.parseInt(prop.getDefault())));
                break;
            }
            case BOOLEAN: {
                if (prop.isList()) {
                    prop.set(this.data.getBooleanList(id, Utils.toBooleanArray(prop.getDefaults())));
                    break;
                }
                prop.set(this.data.getBoolean(id, Boolean.parseBoolean(prop.getDefault())));
                break;
            }
            case DOUBLE: {
                if (prop.isList()) {
                    prop.set(this.data.getDoubleList(id, Utils.toDoubleArray(prop.getDefaults())));
                    break;
                }
                prop.set(this.data.getDouble(id, Double.parseDouble(prop.getDefault())));
                break;
            }
        }
        return this;
    }

    @Nonnull
    public ConfigurationHelper load(@Nonnull ConfigCategory category) {
        return this.load(category, DEFAULT_FILTER);
    }

    @Nonnull
    public ConfigurationHelper load(@Nonnull ConfigCategory category, @Nonnull IConfigFilter filter) {
        if (!filter.skipCategory(category)) {
            for (Map.Entry e : category.getValues().entrySet()) {
                if (filter.skipProperty(category, (Property)e.getValue())) continue;
                this.load(category, (Property)e.getValue());
            }
            for (ConfigCategory c : category.getChildren()) {
                this.load(c, filter);
            }
        }
        return this;
    }

    @Nonnull
    public ConfigurationHelper save(@Nonnull ConfigCategory category) {
        return this.save(category, DEFAULT_FILTER);
    }

    @Nonnull
    public ConfigurationHelper save(@Nonnull ConfigCategory category, @Nonnull IConfigFilter filter) {
        if (!filter.skipCategory(category)) {
            if (category.requiresMcRestart() || category.requiresWorldRestart()) {
                this.data.restartRequired();
            }
            for (Map.Entry e : category.getValues().entrySet()) {
                if (filter.skipProperty(category, (Property)e.getValue())) continue;
                this.save(category, (Property)e.getValue());
            }
            for (ConfigCategory c : category.getChildren()) {
                this.save(c, filter);
            }
        }
        return this;
    }

    @Nonnull
    public ConfigurationHelper load(@Nonnull Configuration config) {
        return this.load(config, DEFAULT_FILTER);
    }

    @Nonnull
    public ConfigurationHelper load(@Nonnull Configuration config, @Nonnull IConfigFilter filter) {
        for (String cat : config.getCategoryNames()) {
            this.load(config.getCategory(cat), filter);
        }
        return this;
    }

    @Nonnull
    public ConfigurationHelper save(@Nonnull Configuration config) {
        return this.save(config, DEFAULT_FILTER);
    }

    @Nonnull
    public ConfigurationHelper save(@Nonnull Configuration config, @Nonnull IConfigFilter filter) {
        for (String cat : config.getCategoryNames()) {
            this.save(config.getCategory(cat), filter);
        }
        return this;
    }

    public static interface IConfigFilter {
        public boolean skipCategory(@Nonnull ConfigCategory var1);

        public boolean skipProperty(@Nonnull ConfigCategory var1, @Nonnull Property var2);
    }
}

