/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.Presets.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.Presets.Presets;
import org.blockartistry.Presets.data.PresetConfig;
import org.blockartistry.Presets.data.PresetInfo;
import org.blockartistry.Presets.gui.PresetInfoModifyGui;
import org.blockartistry.lib.Color;
import org.blockartistry.lib.Localization;
import org.blockartistry.lib.gui.GuiTooltip;
import org.blockartistry.lib.gui.Panel;
import org.blockartistry.lib.gui.StandardPanel;

@SideOnly(value=Side.CLIENT)
public class PresetsConfigGui
extends GuiScreen
implements GuiYesNoCallback,
GuiTooltip.ITooltipRenderer {
    protected static final String PREV_BUTTON_TEXT = "<<<";
    protected static final String NEXT_BUTTON_TEXT = ">>>";
    protected final String TITLE = Localization.format("msg.presets", new Object[0]);
    protected final String APPLY_WARNING_TEXT = Localization.format("presets.dlg.ApplyWarning", new Object[0]);
    protected final String SAVE_WARNING_TEXT = Localization.format("presets.dlg.SaveWarning", new Object[0]);
    protected final String DELETE_WARNING_TEXT = Localization.format("presets.dlg.DeleteWarning", new Object[0]);
    protected final String RESTART_REQUIRED_TEXT = TextFormatting.RED + Localization.format("presets.dlg.RestartRequired", new Object[0]) + TextFormatting.RESET;
    protected final String TOOLTIP_RESTART_REQUIRED = TextFormatting.RED + Localization.format("presets.dlg.RestartRequired.tooltip", new Object[0]) + TextFormatting.RESET;
    protected static final int ID_TITLE = 500;
    protected static final int ID_DONE = 1000;
    protected static final int ID_APPLY = 1001;
    protected static final int ID_REFRESH = 1002;
    protected static final int ID_PREV_PAGE = 1003;
    protected static final int ID_NEXT_PAGE = 1004;
    protected static final int ID_CREATE = 1005;
    protected static final int ID_SAVE = 1006;
    protected static final int ID_DELETE = 1007;
    protected static final int ID_EDIT = 1008;
    protected static final int ID_PRESET_BASE = 1101;
    protected static final int PRESET_TOOLTIP_WIDTH = 300;
    protected static final int REGION_WIDTH = 335;
    protected static final int REGION_HEIGHT = 195;
    protected static final int MARGIN = 10;
    protected static final int INSET = 5;
    protected static final int MAX_PRESETS_PAGE = 5;
    protected static final int BUTTON_WIDTH = 100;
    protected static final int BUTTON_HEIGHT = 20;
    protected static final int PRESET_BUTTON_WIDTH = 200;
    protected static final int PRESET_BUTTON_HEIGHT = 20;
    protected static final int NAV_BUTTON_WIDTH = 25;
    protected static final int NAV_BUTTON_INSET = 5;
    protected final GuiScreen parentScreen;
    protected final PresetConfig config;
    protected final StandardPanel backgroundPanel = new StandardPanel();
    protected final StandardPanel presetPanel = new StandardPanel(0, 0, Color.GOLD, Color.BLACK, Color.GRAY);
    protected int anchorX;
    protected int anchorY;
    protected int regionWidth;
    protected int regionHeight;
    protected int currentPage = 0;
    protected int selectedPreset = -1;
    protected int maxPage;
    protected List<PresetInfo> presets;
    protected final List<GuiButtonExt> presetButtons = Lists.newArrayList();
    protected final List<GuiTooltip> tooltips = Lists.newArrayList();
    protected final List<GuiTooltip> buttonTips = Lists.newArrayList();
    protected GuiButtonExt previousButton;
    protected GuiButtonExt nextButton;
    protected GuiButtonExt refreshButton;
    protected GuiButtonExt applyButton;
    protected GuiButtonExt createButton;
    protected GuiButtonExt editButton;
    protected GuiButtonExt saveButton;
    protected GuiButtonExt deleteButton;

    public PresetsConfigGui(@Nonnull GuiScreen parent) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.parentScreen = parent;
        this.config = new PresetConfig(Presets.dataDirectory());
    }

    protected GuiButtonExt setupButton(int id, int x, int y, @Nonnull String buttonLabel) {
        String label = Localization.format(buttonLabel, new Object[0]);
        String tip = Localization.format(buttonLabel + ".tooltip", new Object[0]);
        GuiButtonExt button = new GuiButtonExt(id, x, y, 100, 20, label);
        this.field_146292_n.add(button);
        if (!tip.endsWith(".tooltip")) {
            this.buttonTips.add(new GuiTooltip(this, (GuiButton)button, tip));
        }
        return button;
    }

    public void func_73866_w_() {
        this.presetButtons.clear();
        this.tooltips.clear();
        this.buttonTips.clear();
        this.field_146293_o.clear();
        this.field_146292_n.clear();
        this.anchorX = (this.field_146294_l - 335) / 2;
        this.anchorY = (this.field_146295_m - 195) / 2;
        int titleWidth = this.field_146289_q.func_78256_a(this.TITLE);
        int titleX = this.anchorX + (335 - titleWidth) / 2;
        int Y = this.anchorY + 5;
        GuiLabel title = new GuiLabel(this.field_146289_q, 500, titleX, Y, 335, 20, Color.MC_GOLD.rgb());
        title.func_175202_a(this.TITLE);
        this.field_146293_o.add(title);
        Y += 25;
        int presetWidth = 210;
        int presetHeight = 135;
        this.presetPanel.setWidth(210);
        this.presetPanel.setHeight(135);
        for (int i = 0; i < 5; ++i) {
            int id = 1101 + i;
            int x = this.anchorX + 10 + 5;
            int y = Y + i * 20;
            GuiButtonExt button = new GuiButtonExt(id, x, y, 200, 20, "<NOT SET>");
            button.field_146125_m = false;
            this.presetButtons.add(button);
            this.tooltips.add(new GuiTooltip(this, (GuiButton)button, ""));
        }
        Y += 100;
        this.field_146292_n.addAll(this.presetButtons);
        int navButtonX = this.anchorX + 10 + 5 + 5;
        this.previousButton = new GuiButtonExt(1003, navButtonX, Y += 5, 25, 20, PREV_BUTTON_TEXT);
        this.field_146292_n.add(this.previousButton);
        navButtonX = this.anchorX + 10 + 210 - 5 - 25 - 5;
        this.nextButton = new GuiButtonExt(1004, navButtonX, Y, 25, 20, NEXT_BUTTON_TEXT);
        this.field_146292_n.add(this.nextButton);
        int offset = 2;
        int buttonsX = this.anchorX + 10 + 210 + 5;
        int buttonsY = this.anchorY + 20 + 5 + 2;
        this.refreshButton = this.setupButton(1002, buttonsX, buttonsY, "presets.button.Refresh");
        this.createButton = this.setupButton(1005, buttonsX, buttonsY += 22, "presets.button.Create");
        this.editButton = this.setupButton(1008, buttonsX, buttonsY += 22, "presets.button.Edit");
        this.applyButton = this.setupButton(1001, buttonsX, buttonsY += 22, "presets.button.Apply");
        this.saveButton = this.setupButton(1006, buttonsX, buttonsY += 22, "presets.button.Save");
        this.deleteButton = this.setupButton(1007, buttonsX, buttonsY += 22, "presets.button.Delete");
        this.regionWidth = 335;
        this.regionHeight = 195;
        this.backgroundPanel.setWidth(this.regionWidth);
        this.backgroundPanel.setHeight(this.regionHeight);
        int doneX = (this.regionWidth - 100) / 2 + this.anchorX;
        int doneY = this.anchorY + this.regionHeight - 30;
        this.setupButton(1000, doneX, doneY, "presets.button.Done");
        this.reload();
    }

    public void reload() {
        this.currentPage = 0;
        this.selectedPreset = -1;
        this.config.scan();
        this.presets = this.config.getPresets();
        this.maxPage = (this.presets.size() - 1) / 5;
        this.setPresetButtonText();
    }

    public void setPresetButtonText() {
        int start = this.currentPage * 5;
        for (int i = 0; i < 5; ++i) {
            GuiButtonExt button = this.presetButtons.get(i);
            int idx = start + i;
            if (idx >= this.presets.size()) {
                button.field_146125_m = false;
                continue;
            }
            PresetInfo info = this.presets.get(idx);
            button.field_146126_j = info.getTitle();
            button.field_146124_l = this.selectedPreset != idx;
            button.field_146125_m = true;
            StringBuilder builder = new StringBuilder();
            builder.append(TextFormatting.GOLD + info.getTitle()).append('\n');
            builder.append(TextFormatting.AQUA + info.getFilename());
            if (info.isRestartRequired()) {
                builder.append('\n').append(this.TOOLTIP_RESTART_REQUIRED);
            }
            if (!StringUtils.isEmpty((CharSequence)info.getDescription().trim())) {
                builder.append("\n\n").append(TextFormatting.RESET).append(info.getDescription());
            }
            this.tooltips.set(i, new GuiTooltip(this, (GuiButton)button, builder.toString(), 300));
        }
        this.updateButtonState();
    }

    protected void updateButtonState() {
        this.previousButton.field_146124_l = this.currentPage > 0;
        this.nextButton.field_146124_l = this.currentPage < this.maxPage;
        this.applyButton.field_146124_l = this.selectedPreset != -1;
        this.saveButton.field_146124_l = this.selectedPreset != -1;
        this.deleteButton.field_146124_l = this.selectedPreset != -1;
        this.editButton.field_146124_l = this.selectedPreset != -1;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.backgroundPanel.render(this.anchorX, this.anchorY, Panel.Reference.UPPER_LEFT);
        this.presetPanel.render(this.anchorX + 10, this.anchorY + 10 + 15, Panel.Reference.UPPER_LEFT);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (int i = 0; i < 5; ++i) {
            GuiButtonExt button = this.presetButtons.get(i);
            if (!button.field_146125_m || !this.tooltips.get(i).handle(mouseX, mouseY)) continue;
            return;
        }
        for (GuiTooltip tip : this.buttonTips) {
            if (!tip.handle(mouseX, mouseY)) continue;
            return;
        }
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        PresetInfo pi = this.selectedPreset != -1 ? this.presets.get(this.selectedPreset) : null;
        switch (button.field_146127_k) {
            case 1000: {
                this.field_146297_k.func_147108_a(this.parentScreen);
                break;
            }
            case 1001: {
                StringBuilder builder = new StringBuilder();
                builder.append(pi.getTitle());
                if (pi.isRestartRequired()) {
                    builder.append("\n\n").append(this.RESTART_REQUIRED_TEXT);
                }
                GuiYesNo yn = new GuiYesNo((GuiYesNoCallback)this, this.APPLY_WARNING_TEXT, builder.toString(), 1001);
                this.field_146297_k.func_147108_a((GuiScreen)yn);
                break;
            }
            case 1005: {
                pi = new PresetInfo();
                PresetInfoModifyGui gui = new PresetInfoModifyGui(this, pi, false, 1005);
                this.field_146297_k.func_147108_a((GuiScreen)gui);
                break;
            }
            case 1008: {
                PresetInfoModifyGui gui = new PresetInfoModifyGui(this, pi, true, 1008);
                this.field_146297_k.func_147108_a((GuiScreen)gui);
                break;
            }
            case 1006: {
                GuiYesNo yn = new GuiYesNo((GuiYesNoCallback)this, this.SAVE_WARNING_TEXT, pi.getTitle(), 1006);
                this.field_146297_k.func_147108_a((GuiScreen)yn);
                break;
            }
            case 1007: {
                GuiYesNo yn = new GuiYesNo((GuiYesNoCallback)this, this.DELETE_WARNING_TEXT, pi.getTitle(), 1007);
                this.field_146297_k.func_147108_a((GuiScreen)yn);
                break;
            }
            case 1002: {
                this.reload();
                break;
            }
            case 1003: {
                if (this.currentPage <= 0) break;
                --this.currentPage;
                this.setPresetButtonText();
                break;
            }
            case 1004: {
                if (this.currentPage >= this.maxPage) break;
                ++this.currentPage;
                this.setPresetButtonText();
                break;
            }
            default: {
                int buttonMashed = button.field_146127_k - 1101;
                if (buttonMashed < 0 || buttonMashed >= 5) {
                    super.func_146284_a(button);
                    break;
                }
                if (this.selectedPreset != -1) {
                    int low = this.currentPage * 5;
                    int high = low + 5;
                    if (this.selectedPreset >= low && this.selectedPreset < high) {
                        int idx = this.selectedPreset % 5;
                        this.presetButtons.get((int)idx).field_146124_l = true;
                    }
                }
                this.selectedPreset = this.currentPage * 5 + buttonMashed;
                this.presetButtons.get((int)buttonMashed).field_146124_l = false;
                this.updateButtonState();
            }
        }
    }

    public void func_73878_a(boolean answer, int buttonId) {
        PresetInfo pi = this.presets.get(this.selectedPreset);
        switch (buttonId) {
            case 1006: {
                if (!answer) break;
                this.config.collectPreset(pi);
                this.config.save(pi);
                break;
            }
            case 1007: {
                if (!answer) break;
                this.config.delete(pi);
                this.reload();
                break;
            }
            case 1001: {
                if (!answer) break;
                this.config.applyPreset(pi);
            }
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    public void confirmUpdate(boolean answer, int buttonId, PresetInfo info) {
        switch (buttonId) {
            case 1005: {
                if (answer) {
                    this.config.collectPreset(info);
                    this.config.save(info);
                    this.reload();
                }
            }
            case 1008: {
                if (!answer) break;
                this.config.save(info);
                this.reload();
            }
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.parentScreen instanceof GuiConfig) {
            GuiConfig parentGuiConfig = (GuiConfig)this.parentScreen;
            parentGuiConfig.needsRefresh = true;
            parentGuiConfig.func_73866_w_();
        }
    }

    @Override
    public void drawTooltip(int x, int y, @Nonnull List<String> text) {
        this.func_146283_a(text, x, y);
    }
}

