/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.Presets.handler;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.Presets.Presets;
import org.blockartistry.Presets.api.PresetData;
import org.blockartistry.Presets.api.events.PresetEvent;
import org.lwjgl.opengl.Display;

@SideOnly(value=Side.CLIENT)
public class MinecraftConfigHandler {
    private static final String MINECRAFT = "minecraft";
    private static final String SOUND_PREFIX = "soundCategory_";
    private static final String KEYBIND_PREFIX = "key_";

    @SubscribeEvent
    public static void onConfigSave(@Nonnull PresetEvent.Save event) {
        PresetData data = event.getModData(MINECRAFT);
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        block41: for (GameSettings.Options options : GameSettings.Options.values()) {
            String theName = options.func_74378_d();
            switch (options) {
                case INVERT_MOUSE: {
                    data.setBoolean(theName, settings.field_74338_d);
                    continue block41;
                }
                case SENSITIVITY: {
                    data.setDouble(theName, settings.field_74341_c);
                    continue block41;
                }
                case FOV: {
                    data.setDouble(theName, settings.field_74334_X);
                    continue block41;
                }
                case GAMMA: {
                    data.setDouble(theName, settings.field_74333_Y);
                    continue block41;
                }
                case SATURATION: {
                    data.setDouble(theName, settings.field_151452_as);
                    continue block41;
                }
                case RENDER_DISTANCE: {
                    data.setInt(theName, settings.field_151451_c);
                    continue block41;
                }
                case VIEW_BOBBING: {
                    data.setBoolean(theName, settings.field_74336_f);
                    continue block41;
                }
                case ANAGLYPH: {
                    data.setBoolean(theName, settings.field_74337_g);
                    continue block41;
                }
                case FRAMERATE_LIMIT: {
                    data.setInt(theName, settings.field_74350_i);
                    continue block41;
                }
                case FBO_ENABLE: {
                    data.setBoolean(theName, settings.field_151448_g);
                    continue block41;
                }
                case CHAT_COLOR: {
                    data.setBoolean(theName, settings.field_74344_o);
                    continue block41;
                }
                case CHAT_LINKS: {
                    data.setBoolean(theName, settings.field_74359_p);
                    continue block41;
                }
                case CHAT_OPACITY: {
                    data.setDouble(theName, settings.field_74357_r);
                    continue block41;
                }
                case CHAT_LINKS_PROMPT: {
                    data.setBoolean(theName, settings.field_74358_q);
                    continue block41;
                }
                case SNOOPER_ENABLED: {
                    data.setBoolean(theName, settings.field_74355_t);
                    continue block41;
                }
                case USE_FULLSCREEN: {
                    data.setBoolean(theName, settings.field_74353_u);
                    continue block41;
                }
                case ENABLE_VSYNC: {
                    data.setBoolean(theName, settings.field_74352_v);
                    continue block41;
                }
                case USE_VBO: {
                    data.setBoolean(theName, settings.field_178881_t);
                    continue block41;
                }
                case TOUCHSCREEN: {
                    data.setBoolean(theName, settings.field_85185_A);
                    continue block41;
                }
                case CHAT_SCALE: {
                    data.setDouble(theName, settings.field_96691_E);
                    continue block41;
                }
                case CHAT_WIDTH: {
                    data.setDouble(theName, settings.field_96692_F);
                    continue block41;
                }
                case CHAT_HEIGHT_FOCUSED: {
                    data.setDouble(theName, settings.field_96694_H);
                    continue block41;
                }
                case CHAT_HEIGHT_UNFOCUSED: {
                    data.setDouble(theName, settings.field_96693_G);
                    continue block41;
                }
                case MIPMAP_LEVELS: {
                    data.setInt(theName, settings.field_151442_I);
                    continue block41;
                }
                case FORCE_UNICODE_FONT: {
                    data.setBoolean(theName, settings.field_151455_aw);
                    continue block41;
                }
                case REDUCED_DEBUG_INFO: {
                    data.setBoolean(theName, settings.field_178879_v);
                    continue block41;
                }
                case ENTITY_SHADOWS: {
                    data.setBoolean(theName, settings.field_181151_V);
                    continue block41;
                }
                case ENABLE_WEAK_ATTACKS: {
                    data.setBoolean(theName, settings.field_189422_N);
                    continue block41;
                }
                case SHOW_SUBTITLES: {
                    data.setBoolean(theName, settings.field_186717_N);
                    continue block41;
                }
                case REALMS_NOTIFICATIONS: {
                    data.setBoolean(theName, settings.field_183509_X);
                    continue block41;
                }
                case AUTO_JUMP: {
                    data.setBoolean(theName, settings.field_189989_R);
                    continue block41;
                }
                case RENDER_CLOUDS: {
                    data.setInt(theName, settings.field_74345_l);
                    continue block41;
                }
                case GRAPHICS: {
                    data.setBoolean(theName, settings.field_74347_j);
                    continue block41;
                }
                case AMBIENT_OCCLUSION: {
                    data.setInt(theName, settings.field_74348_k);
                    continue block41;
                }
                case GUI_SCALE: {
                    data.setInt(theName, settings.field_74335_Z);
                    continue block41;
                }
                case PARTICLES: {
                    data.setInt(theName, settings.field_74362_aa);
                    continue block41;
                }
                case CHAT_VISIBILITY: {
                    data.setInt(theName, settings.field_74343_n.ordinal());
                    continue block41;
                }
                case MAIN_HAND: {
                    data.setString(theName, settings.field_186715_A.name());
                    continue block41;
                }
                case ATTACK_INDICATOR: {
                    data.setInt(theName, settings.field_186716_M);
                    continue block41;
                }
            }
        }
        for (GameSettings.Options options : SoundCategory.values()) {
            data.setDouble(SOUND_PREFIX + options.func_187948_a(), settings.func_186711_a((SoundCategory)options));
        }
        for (GameSettings.Options options : settings.field_74324_K) {
            String id = KEYBIND_PREFIX + options.func_151464_g();
            String val = Integer.toString(options.func_151463_i());
            if (options.getKeyModifier() != KeyModifier.NONE) {
                val = val + ":" + options.getKeyModifier();
            }
            data.setString(id, val);
        }
    }

    @SubscribeEvent
    public static void onConfigLoad(@Nonnull PresetEvent.Load event) {
        PresetData data = event.getModData(MINECRAFT);
        if (data != null) {
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            boolean refreshChat = false;
            boolean refreshMipmaps = false;
            boolean refreshRenderDistance = false;
            boolean refreshRenderers = false;
            boolean refreshUnicodeFlag = false;
            boolean refreshResources = false;
            boolean refreshVsync = false;
            block41: for (Map.Entry<String, String> e : data.getEntries()) {
                if (e.getKey().startsWith(SOUND_PREFIX)) {
                    String catName = e.getKey().replace(SOUND_PREFIX, "");
                    SoundCategory sc = SoundCategory.func_187950_a((String)catName);
                    if (sc != null) {
                        settings.func_186712_a(sc, (float)Double.parseDouble(e.getValue()));
                        continue;
                    }
                    Presets.log().warn("Unknown sound category: %s", catName);
                    continue;
                }
                if (e.getKey().startsWith(KEYBIND_PREFIX)) {
                    boolean found = false;
                    String keyName = e.getKey().replace(KEYBIND_PREFIX, "");
                    for (KeyBinding binding : settings.field_74324_K) {
                        if (!keyName.equals(binding.func_151464_g())) continue;
                        String[] parts = StringUtils.split((String)e.getValue(), (char)':');
                        int keyCode = Integer.parseInt(parts[0]);
                        KeyModifier modifier = parts.length == 1 ? KeyModifier.NONE : KeyModifier.valueFromString((String)parts[1]);
                        binding.setKeyModifierAndCode(modifier, keyCode);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    Presets.log().warn("Unknown keybinding found: %s", keyName);
                    continue;
                }
                String theName = e.getKey();
                GameSettings.Options option = MinecraftConfigHandler.getOptionByName(theName);
                if (option != null) {
                    switch (option) {
                        case INVERT_MOUSE: {
                            settings.field_74338_d = data.getBoolean(theName, settings.field_74338_d);
                            continue block41;
                        }
                        case SENSITIVITY: {
                            settings.field_74341_c = (float)data.getDouble(theName, settings.field_74341_c);
                            continue block41;
                        }
                        case FOV: {
                            settings.field_74334_X = (float)data.getDouble(theName, settings.field_74334_X);
                            continue block41;
                        }
                        case GAMMA: {
                            settings.field_74333_Y = (float)data.getDouble(theName, settings.field_74333_Y);
                            continue block41;
                        }
                        case SATURATION: {
                            settings.field_151452_as = (float)data.getDouble(theName, settings.field_151452_as);
                            continue block41;
                        }
                        case RENDER_DISTANCE: {
                            int rd = data.getInt(theName, settings.field_151451_c);
                            if (settings.field_151451_c == rd) continue block41;
                            settings.field_151451_c = rd;
                            refreshRenderDistance = true;
                            continue block41;
                        }
                        case VIEW_BOBBING: {
                            settings.field_74336_f = data.getBoolean(theName, settings.field_74336_f);
                            continue block41;
                        }
                        case ANAGLYPH: {
                            boolean anal = data.getBoolean(theName, settings.field_74337_g);
                            if (settings.field_74337_g == anal) continue block41;
                            settings.field_74337_g = anal;
                            refreshResources = true;
                            continue block41;
                        }
                        case FRAMERATE_LIMIT: {
                            settings.field_74350_i = data.getInt(theName, settings.field_74350_i);
                            continue block41;
                        }
                        case FBO_ENABLE: {
                            settings.field_151448_g = data.getBoolean(theName, settings.field_151448_g);
                            continue block41;
                        }
                        case CHAT_COLOR: {
                            settings.field_74344_o = data.getBoolean(theName, settings.field_74344_o);
                            refreshChat = true;
                            continue block41;
                        }
                        case CHAT_LINKS: {
                            settings.field_74359_p = data.getBoolean(theName, settings.field_74359_p);
                            refreshChat = true;
                            continue block41;
                        }
                        case CHAT_OPACITY: {
                            settings.field_74357_r = (float)data.getDouble(theName, settings.field_74357_r);
                            refreshChat = true;
                            continue block41;
                        }
                        case CHAT_LINKS_PROMPT: {
                            settings.field_74358_q = data.getBoolean(theName, settings.field_74358_q);
                            refreshChat = true;
                            continue block41;
                        }
                        case SNOOPER_ENABLED: {
                            settings.field_74355_t = data.getBoolean(theName, settings.field_74355_t);
                            continue block41;
                        }
                        case USE_FULLSCREEN: {
                            settings.field_74353_u = data.getBoolean(theName, settings.field_74353_u);
                            continue block41;
                        }
                        case ENABLE_VSYNC: {
                            boolean vsync = data.getBoolean(theName, settings.field_74352_v);
                            if (settings.field_74352_v == vsync) continue block41;
                            settings.field_74352_v = vsync;
                            refreshVsync = true;
                            continue block41;
                        }
                        case USE_VBO: {
                            boolean vbo = data.getBoolean(theName, settings.field_178881_t);
                            if (settings.field_178881_t == vbo) continue block41;
                            settings.field_178881_t = vbo;
                            refreshRenderers = true;
                            continue block41;
                        }
                        case TOUCHSCREEN: {
                            settings.field_85185_A = data.getBoolean(theName, settings.field_85185_A);
                            continue block41;
                        }
                        case CHAT_SCALE: {
                            settings.field_96691_E = (float)data.getDouble(theName, settings.field_96691_E);
                            refreshChat = true;
                            continue block41;
                        }
                        case CHAT_WIDTH: {
                            settings.field_96692_F = (float)data.getDouble(theName, settings.field_96692_F);
                            refreshChat = true;
                            continue block41;
                        }
                        case CHAT_HEIGHT_FOCUSED: {
                            settings.field_96694_H = (float)data.getDouble(theName, settings.field_96694_H);
                            refreshChat = true;
                            continue block41;
                        }
                        case CHAT_HEIGHT_UNFOCUSED: {
                            settings.field_96693_G = (float)data.getDouble(theName, settings.field_96693_G);
                            refreshChat = true;
                            continue block41;
                        }
                        case MIPMAP_LEVELS: {
                            int mips = data.getInt(theName, settings.field_151442_I);
                            if (settings.field_151442_I == mips) continue block41;
                            settings.field_151442_I = mips;
                            refreshMipmaps = true;
                            continue block41;
                        }
                        case FORCE_UNICODE_FONT: {
                            boolean force = data.getBoolean(theName, settings.field_151455_aw);
                            if (settings.field_151455_aw == force) continue block41;
                            settings.field_151455_aw = force;
                            refreshUnicodeFlag = true;
                            continue block41;
                        }
                        case REDUCED_DEBUG_INFO: {
                            settings.field_178879_v = data.getBoolean(theName, settings.field_178879_v);
                            continue block41;
                        }
                        case ENTITY_SHADOWS: {
                            settings.field_181151_V = data.getBoolean(theName, settings.field_181151_V);
                            continue block41;
                        }
                        case ENABLE_WEAK_ATTACKS: {
                            settings.field_189422_N = data.getBoolean(theName, settings.field_189422_N);
                            continue block41;
                        }
                        case SHOW_SUBTITLES: {
                            settings.field_186717_N = data.getBoolean(theName, settings.field_186717_N);
                            continue block41;
                        }
                        case REALMS_NOTIFICATIONS: {
                            settings.field_183509_X = data.getBoolean(theName, settings.field_183509_X);
                            continue block41;
                        }
                        case AUTO_JUMP: {
                            settings.field_189989_R = data.getBoolean(theName, settings.field_189989_R);
                            continue block41;
                        }
                        case RENDER_CLOUDS: {
                            settings.field_74345_l = data.getInt(theName, settings.field_74345_l);
                            continue block41;
                        }
                        case GRAPHICS: {
                            boolean fancy = data.getBoolean(theName, settings.field_74347_j);
                            if (settings.field_74347_j == fancy) continue block41;
                            settings.field_74347_j = fancy;
                            refreshRenderers = true;
                            continue block41;
                        }
                        case AMBIENT_OCCLUSION: {
                            int occlusion = data.getInt(theName, settings.field_74348_k);
                            if (settings.field_74348_k == occlusion) continue block41;
                            settings.field_74348_k = occlusion;
                            refreshRenderers = true;
                            continue block41;
                        }
                        case GUI_SCALE: {
                            settings.field_74335_Z = data.getInt(theName, settings.field_74335_Z);
                            continue block41;
                        }
                        case PARTICLES: {
                            settings.field_74362_aa = data.getInt(theName, settings.field_74362_aa);
                            continue block41;
                        }
                        case CHAT_VISIBILITY: {
                            settings.field_74343_n = EntityPlayer.EnumChatVisibility.func_151426_a((int)data.getInt(theName, settings.field_74343_n.ordinal()));
                            continue block41;
                        }
                        case MAIN_HAND: {
                            settings.field_186715_A = EnumHandSide.valueOf((String)data.getString(theName, settings.field_186715_A.name()));
                            continue block41;
                        }
                        case ATTACK_INDICATOR: {
                            settings.field_186716_M = data.getInt(theName, settings.field_186716_M);
                            continue block41;
                        }
                    }
                    continue;
                }
                Presets.log().warn("Unknown option value: %s", theName);
            }
            settings.func_74303_b();
            Minecraft mc = Minecraft.func_71410_x();
            if (refreshChat) {
                mc.field_71456_v.func_146158_b().func_146245_b();
            }
            if (refreshMipmaps) {
                mc.func_147117_R().func_147633_a(settings.field_151442_I);
                mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                mc.func_147117_R().func_174937_a(false, settings.field_151442_I > 0);
                refreshResources = true;
            }
            if (refreshRenderDistance) {
                mc.field_71438_f.func_174979_m();
            }
            if (refreshRenderers) {
                mc.field_71438_f.func_72712_a();
            }
            if (refreshUnicodeFlag) {
                mc.field_71466_p.func_78264_a(mc.func_135016_M().func_135042_a() || settings.field_151455_aw);
            }
            if (refreshResources) {
                mc.func_110436_a();
            }
            if (refreshVsync) {
                Display.setVSyncEnabled((boolean)settings.field_74352_v);
            }
            if (settings.field_74353_u != mc.func_71372_G()) {
                mc.func_71352_k();
            }
        }
    }

    @Nullable
    private static GameSettings.Options getOptionByName(@Nonnull String name) {
        for (GameSettings.Options o : GameSettings.Options.values()) {
            if (!name.equals(o.func_74378_d())) continue;
            return o;
        }
        return null;
    }
}

