/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public final class BlockPosHelper {
    private BlockPosHelper() {
    }

    public static BlockPos getNonOffsetPos(@Nonnull Entity entity) {
        return new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public static BlockPos.MutableBlockPos setPos(@Nonnull BlockPos.MutableBlockPos pos, @Nonnull Vec3d vec) {
        return pos.func_189532_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static boolean canFormCuboid(@Nonnull BlockPos p1, @Nonnull BlockPos p2) {
        return p1.func_177958_n() != p2.func_177958_n() && p1.func_177952_p() != p2.func_177952_p() && p1.func_177956_o() != p2.func_177956_o();
    }

    public static BlockPos createMinPoint(@Nonnull BlockPos p1, @Nonnull BlockPos p2) {
        return new BlockPos(Math.min(p1.func_177958_n(), p2.func_177958_n()), Math.min(p1.func_177956_o(), p2.func_177956_o()), Math.min(p1.func_177952_p(), p2.func_177952_p()));
    }

    public static BlockPos createMaxPoint(@Nonnull BlockPos p1, @Nonnull BlockPos p2) {
        return new BlockPos(Math.max(p1.func_177958_n(), p2.func_177958_n()), Math.max(p1.func_177956_o(), p2.func_177956_o()), Math.max(p1.func_177952_p(), p2.func_177952_p()));
    }

    public static boolean contains(@Nonnull BlockPos test, @Nonnull BlockPos min, @Nonnull BlockPos max) {
        return test.func_177958_n() >= min.func_177958_n() && test.func_177958_n() <= max.func_177958_n() ? (test.func_177956_o() >= min.func_177956_o() && test.func_177956_o() <= max.func_177956_o() ? test.func_177952_p() >= min.func_177952_p() && test.func_177952_p() <= max.func_177952_p() : false) : false;
    }

    public static Iterable<BlockPos.MutableBlockPos> getAllInBoxMutable(BlockPos from, BlockPos to) {
        final BlockPos blockpos = BlockPosHelper.createMinPoint(from, to);
        final BlockPos blockpos1 = BlockPosHelper.createMaxPoint(from, to);
        return new Iterable<BlockPos.MutableBlockPos>(){

            @Override
            public Iterator<BlockPos.MutableBlockPos> iterator() {
                return new AbstractIterator<BlockPos.MutableBlockPos>(){
                    private BlockPos.MutableBlockPos theBlockPos;

                    protected BlockPos.MutableBlockPos computeNext() {
                        if (this.theBlockPos == null) {
                            this.theBlockPos = new BlockPos.MutableBlockPos(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
                            return this.theBlockPos;
                        }
                        if (this.theBlockPos.equals((Object)blockpos1)) {
                            return (BlockPos.MutableBlockPos)this.endOfData();
                        }
                        int i = this.theBlockPos.func_177958_n();
                        int j = this.theBlockPos.func_177956_o();
                        int k = this.theBlockPos.func_177952_p();
                        if (j < blockpos1.func_177956_o()) {
                            ++j;
                        } else if (i < blockpos1.func_177958_n()) {
                            j = blockpos.func_177956_o();
                            ++i;
                        } else if (k < blockpos1.func_177952_p()) {
                            i = blockpos.func_177958_n();
                            j = blockpos.func_177956_o();
                            ++k;
                        }
                        this.theBlockPos.func_181079_c(i, j, k);
                        return this.theBlockPos;
                    }
                };
            }
        };
    }
}

