/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class BlockStateProvider {
    public static final IBlockState AIR_STATE = Blocks.field_150350_a.func_176223_P();
    protected static final WeakReference<Chunk> NULL_CHUNK = new WeakReference<Object>(null);
    protected final BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
    protected WeakReference<World> world;
    protected WeakReference<Chunk> chunk;

    public BlockStateProvider() {
        this(null);
    }

    public BlockStateProvider(World world) {
        this.world = new WeakReference<World>(world);
        this.chunk = NULL_CHUNK;
    }

    @Nonnull
    protected Chunk resolveChunk(int x, int z) {
        int cX = x >> 4;
        int cZ = z >> 4;
        Chunk c = null;
        c = (Chunk)this.chunk.get();
        if (c == null || !c.func_76600_a(cX, cZ)) {
            World w = (World)this.world.get();
            if (w == null) {
                this.chunk = NULL_CHUNK;
                c = null;
            } else {
                c = w.func_72964_e(cX, cZ);
                this.chunk = new WeakReference<Chunk>(c);
            }
        }
        return c;
    }

    @Nonnull
    public BlockStateProvider setWorld(@Nonnull World world) {
        if (this.world.get() != world) {
            this.world = new WeakReference<World>(world);
            this.chunk = NULL_CHUNK;
        }
        return this;
    }

    @Nullable
    public World getWorld() {
        return (World)this.world.get();
    }

    @Nonnull
    public IBlockState getBlockState(@Nonnull BlockPos pos) {
        return this.getBlockState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Nonnull
    private IBlockState getBlockState0(Chunk chunk, int x, int y, int z) {
        ExtendedBlockStorage extendedblockstorage;
        ExtendedBlockStorage[] storageArrays;
        int idx;
        if (chunk != null && (idx = y >> 4) < (storageArrays = chunk.func_76587_i()).length && (extendedblockstorage = storageArrays[idx]) != Chunk.field_186036_a) {
            return extendedblockstorage.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
        }
        return AIR_STATE;
    }

    @Nonnull
    public IBlockState getBlockState(int x, int y, int z) {
        return y >= 0 && y < 256 ? this.getBlockState0(this.resolveChunk(x, z), x, y, z) : AIR_STATE;
    }

    public boolean isAvailable(int x, int z) {
        int cX = x >> 4;
        int cZ = z >> 4;
        World w = (World)this.world.get();
        if (w == null) {
            return false;
        }
        Chunk c = (Chunk)this.chunk.get();
        if (c == null || !c.func_76600_a(cX, cZ)) {
            c = w.func_72863_F().func_186026_b(cX, cZ);
            this.chunk = c == null ? NULL_CHUNK : new WeakReference<Chunk>(c);
        }
        return c != null;
    }

    public boolean isAvailable(@Nonnull BlockPos pos) {
        return this.isAvailable(pos.func_177958_n(), pos.func_177952_p());
    }

    public int getLightFor(@Nonnull EnumSkyBlock type, @Nonnull BlockPos pos) {
        Chunk chunk = this.resolveChunk(pos.func_177958_n(), pos.func_177952_p());
        return chunk != null ? chunk.func_177413_a(type, pos) : type.field_77198_c;
    }

    public BlockPos getTopSolidOrLiquidBlock(@Nonnull BlockPos pos) {
        int z;
        int x = pos.func_177958_n();
        Chunk chunk = this.resolveChunk(x, z = pos.func_177952_p());
        if (chunk == null) {
            return pos;
        }
        World world = this.getWorld();
        for (int dY = chunk.func_76625_h() + 16 - 1; dY >= 0; --dY) {
            IBlockState state = this.getBlockState0(chunk, x, dY, z);
            Material material = state.func_185904_a();
            if (!material.func_76230_c() || material == Material.field_151584_j || state.func_177230_c().isFoliage((IBlockAccess)world, (BlockPos)this.mutable.func_181079_c(x, dY, z))) continue;
            return this.mutable.func_185334_h();
        }
        return pos;
    }

    public Biome getBiome(@Nonnull BlockPos pos) {
        int z;
        int x = pos.func_177958_n();
        Chunk chunk = this.resolveChunk(x, z = pos.func_177952_p());
        if (chunk != null) {
            try {
                World world = this.getWorld();
                return chunk.func_177411_a(pos, world.field_73011_w.field_76578_c);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Biomes.field_76772_c;
    }
}

