/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import javax.annotation.Nonnull;
import net.minecraft.world.World;
import org.blockartistry.lib.math.MathStuff;

public final class DiurnalUtils {
    private DiurnalUtils() {
    }

    public static boolean isDaytime(@Nonnull World world) {
        return DiurnalUtils.getCycle(world) == DayCycle.DAYTIME;
    }

    public static boolean isNighttime(@Nonnull World world) {
        return DiurnalUtils.getCycle(world) == DayCycle.NIGHTTIME;
    }

    public static boolean isSunrise(@Nonnull World world) {
        return DiurnalUtils.getCycle(world) == DayCycle.SUNRISE;
    }

    public static boolean isSunset(@Nonnull World world) {
        return DiurnalUtils.getCycle(world) == DayCycle.SUNSET;
    }

    public static DayCycle getCycle(@Nonnull World world) {
        if (world == null || world.field_73011_w == null || world.field_73011_w.field_76579_a == null || world.field_73011_w.func_177495_o()) {
            return DayCycle.NO_SKY;
        }
        float brFactor = world.field_73011_w.getSunBrightnessFactor(1.0f);
        if (brFactor > 0.6f) {
            return DayCycle.DAYTIME;
        }
        if (brFactor < 0.1f) {
            return DayCycle.NIGHTTIME;
        }
        if ((double)MathStuff.sin(world.func_72929_e(1.0f)) > 0.0) {
            return DayCycle.SUNSET;
        }
        return DayCycle.SUNRISE;
    }

    public static float getMoonPhaseFactor(@Nonnull World world) {
        return world == null ? 0.0f : world.func_130001_d();
    }

    public static boolean isAuroraVisible(@Nonnull World world) {
        return !DiurnalUtils.isAuroraInvisible(world);
    }

    public static boolean isAuroraInvisible(@Nonnull World world) {
        DayCycle cycle = DiurnalUtils.getCycle(world);
        return cycle == DayCycle.SUNRISE || cycle == DayCycle.DAYTIME;
    }

    public static enum DayCycle {
        NO_SKY,
        SUNRISE,
        SUNSET,
        DAYTIME,
        NIGHTTIME;

    }
}

