/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.blockartistry.lib.LibLog;

public final class JsonUtils {
    private JsonUtils() {
    }

    @Nonnull
    public static <T> T load(@Nonnull File file, @Nonnull Class<T> clazz) throws Exception {
        try (FileInputStream stream = new FileInputStream(file);){
            if (stream != null) {
                T t = JsonUtils.load(stream, clazz);
                return t;
            }
        }
        return clazz.newInstance();
    }

    @Nonnull
    public static <T> T load(@Nonnull String modId, @Nonnull Class<T> clazz) throws Exception {
        String fileName = modId.replaceAll("[^a-zA-Z0-9.-]", "_");
        try (InputStream stream = clazz.getResourceAsStream("/assets/dsurround/data/" + fileName + ".json");){
            if (stream != null) {
                T t = JsonUtils.load(stream, clazz);
                return t;
            }
        }
        return clazz.newInstance();
    }

    @Nullable
    public static <T> T load(@Nonnull Reader stream, @Nonnull Class<T> clazz) throws Exception {
        try {
            return (T)new Gson().fromJson(stream, clazz);
        }
        catch (Throwable t) {
            LibLog.log().error("Unable to process Json from stream", t);
            return clazz.newInstance();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T load(@Nonnull InputStream stream, @Nonnull Class<T> clazz) throws Exception {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            Object object = new Gson().fromJson((Reader)reader, clazz);
            return (T)object;
        }
        catch (Throwable t) {
            LibLog.log().error("Unable to process Json from stream", t);
            return clazz.newInstance();
        }
    }
}

