/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.Locale;
import net.minecraftforge.fml.relauncher.Side;
import org.blockartistry.lib.Translations;
import org.blockartistry.lib.compat.I18nUtil;
import org.blockartistry.lib.compat.LocaleUtil;

public final class Localization {
    private static Local impl;

    public static void initialize(@Nonnull Side side) {
        impl = side == Side.SERVER ? new ServerImpl() : new ClientImpl();
    }

    @Nonnull
    public static String format(@Nonnull String translateKey, Object ... parameters) {
        return impl.format(translateKey, parameters);
    }

    public static String loadString(@Nonnull String translateKey) {
        return impl.loadString(translateKey);
    }

    private static class ServerImpl
    extends Local {
        private final Translations xlate = new Translations();

        public ServerImpl() {
            this.xlate.load("/assets/dsurround/lang/", "en_US");
        }

        @Override
        public String format(String translateKey, Object ... parameters) {
            return this.xlate.format(translateKey, parameters);
        }

        @Override
        public String loadString(String translateKey) {
            return this.xlate.loadString(translateKey);
        }
    }

    private static class ClientImpl
    extends Local {
        @Override
        public String format(String translateKey, Object ... parameters) {
            return I18n.func_135052_a((String)translateKey, (Object[])parameters);
        }

        @Override
        public String loadString(String translateKey) {
            Locale locale = I18nUtil.getLocale();
            return LocaleUtil.translateKeyPrivate(locale, translateKey);
        }
    }

    private static abstract class Local {
        private Local() {
        }

        public abstract String format(String var1, Object ... var2);

        public abstract String loadString(String var1);
    }
}

