/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.lib.collections.IdentityHashSet;

@SideOnly(value=Side.CLIENT)
public final class MCHelper {
    private static final String MATERIAL_CUSTOM = "Custom";
    private static final String MATERIAL_NONE = "None";
    private static final Map<Material, String> materialMap = new IdentityHashMap<Material, String>();
    private static final Set<Block> hasVariants = new IdentityHashSet();

    private static boolean variantCheck(@Nonnull Block block2) {
        Item item = Item.func_150898_a((Block)block2);
        if (item == null) {
            return false;
        }
        if (item.func_77614_k()) {
            return true;
        }
        ArrayList stacks = new ArrayList();
        try {
            block2.func_149666_a(item, block2.func_149708_J(), stacks);
        }
        catch (Throwable t) {
            return false;
        }
        return stacks.size() > 1;
    }

    protected MCHelper() {
    }

    @Nonnull
    public static String nameOf(@Nonnull Block block2) {
        return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block2)).toString();
    }

    @Nonnull
    public static String nameOf(@Nonnull Item item) {
        return ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString();
    }

    @Nullable
    public static Item getItemByName(@Nonnull String itemName) {
        return Item.func_111206_d((String)itemName);
    }

    @Nonnull
    public static Block getBlockByName(@Nonnull String blockName) {
        return (Block)Block.field_149771_c.getObjectBypass((Object)new ResourceLocation(blockName));
    }

    @Nullable
    public static SoundType getSoundType(@Nonnull Block block2) {
        return block2.func_185467_w();
    }

    @Nullable
    public static SoundType getSoundType(@Nonnull IBlockState state) {
        return MCHelper.getSoundType(state.func_177230_c());
    }

    public static boolean hasVariants(@Nonnull Block block2) {
        return hasVariants.contains(block2);
    }

    public static boolean hasSpecialMeta(@Nonnull Block block2) {
        return block2 instanceof BlockCrops;
    }

    @Nonnull
    public static String getMaterialName(@Nullable Material material) {
        if (material == null) {
            return MATERIAL_NONE;
        }
        String materialName = materialMap.get(material);
        return materialName == null ? MATERIAL_CUSTOM : materialName;
    }

    static {
        materialMap.put(Material.field_151579_a, "Air");
        materialMap.put(Material.field_151574_g, "Anvil");
        materialMap.put(Material.field_175972_I, "Barrier");
        materialMap.put(Material.field_151570_A, "Cactus");
        materialMap.put(Material.field_151568_F, "Cake");
        materialMap.put(Material.field_151593_r, "Carpet");
        materialMap.put(Material.field_151594_q, "Circuits");
        materialMap.put(Material.field_151571_B, "Clay");
        materialMap.put(Material.field_151580_n, "Cloth");
        materialMap.put(Material.field_151589_v, "Coral");
        materialMap.put(Material.field_151596_z, "Crafted Snow");
        materialMap.put(Material.field_151566_D, "Dragon Egg");
        materialMap.put(Material.field_151581_o, "FireJetEffect");
        materialMap.put(Material.field_151592_s, "Glass");
        materialMap.put(Material.field_151572_C, "Gourd");
        materialMap.put(Material.field_151577_b, "Grass");
        materialMap.put(Material.field_151578_c, "Ground");
        materialMap.put(Material.field_151588_w, "Ice");
        materialMap.put(Material.field_151573_f, "Iron");
        materialMap.put(Material.field_151587_i, "Lava");
        materialMap.put(Material.field_151584_j, "Leaves");
        materialMap.put(Material.field_151598_x, "Packed Ice");
        materialMap.put(Material.field_76233_E, "Piston");
        materialMap.put(Material.field_151585_k, "Plants");
        materialMap.put(Material.field_151567_E, "Portal");
        materialMap.put(Material.field_151591_t, "Redstone Light");
        materialMap.put(Material.field_151576_e, "Rock");
        materialMap.put(Material.field_151595_p, "Sand");
        materialMap.put(Material.field_151597_y, "Snow");
        materialMap.put(Material.field_151583_m, "Sponge");
        materialMap.put(Material.field_189963_J, "Structure Void");
        materialMap.put(Material.field_151590_u, "TNT");
        materialMap.put(Material.field_151582_l, "Vine");
        materialMap.put(Material.field_151586_h, "Water");
        materialMap.put(Material.field_151569_G, "Web");
        materialMap.put(Material.field_151575_d, "Wood");
        for (Block block2 : Block.field_149771_c) {
            if (!MCHelper.variantCheck(block2)) continue;
            hasVariants.add(block2);
        }
    }
}

