/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import javax.annotation.Nonnull;
import net.minecraft.world.World;
import org.blockartistry.lib.DiurnalUtils;
import org.blockartistry.lib.Localization;

public class MinecraftClock {
    private static final String AM = Localization.format("dsurround.format.AM", new Object[0]);
    private static final String PM = Localization.format("dsurround.format.PM", new Object[0]);
    private static final String NO_SKY = Localization.format("dsurround.format.NoSky", new Object[0]);
    private static final String SUNRISE = Localization.format("dsurround.format.Sunrise", new Object[0]);
    private static final String SUNSET = Localization.format("dsurround.format.Sunset", new Object[0]);
    private static final String DAYTIME = Localization.format("dsurround.format.Daytime", new Object[0]);
    private static final String NIGHTTIME = Localization.format("dsurround.format.Nighttime", new Object[0]);
    private static final String TIME_FORMAT = Localization.loadString("dsurround.format.TimeOfDay");
    protected int day;
    protected int hour;
    protected int minute;
    protected boolean isAM;
    protected DiurnalUtils.DayCycle cycle = DiurnalUtils.DayCycle.DAYTIME;

    public MinecraftClock() {
    }

    public MinecraftClock(@Nonnull World world) {
        this.update(world);
    }

    public void update(@Nonnull World world) {
        long time = world.func_72820_D();
        this.day = (int)(time / 24000L);
        ++this.day;
        this.hour = (int)((time -= (long)(this.day * 24000)) / 1000L);
        this.minute = (int)((double)(time -= (long)(this.hour * 1000)) / 16.666);
        this.hour += 6;
        if (this.hour >= 24) {
            this.hour -= 24;
            ++this.day;
        }
        this.isAM = this.hour < 12;
        this.cycle = DiurnalUtils.getCycle(world);
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public boolean isAM() {
        return this.isAM;
    }

    public String getTimeOfDay() {
        switch (this.cycle) {
            case NO_SKY: {
                return NO_SKY;
            }
            case SUNRISE: {
                return SUNRISE;
            }
            case SUNSET: {
                return SUNSET;
            }
            case DAYTIME: {
                return DAYTIME;
            }
        }
        return NIGHTTIME;
    }

    public String getFormattedTime() {
        return String.format(TIME_FORMAT, this.day, this.hour > 12 ? this.hour - 12 : this.hour, this.minute, this.isAM ? AM : PM);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return builder.append('[').append(this.getFormattedTime()).append(' ').append(this.getTimeOfDay()).append(']').toString();
    }
}

