/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.lib.ItemStackUtil;
import org.blockartistry.lib.random.XorShiftRandom;

public final class PlayerUtils {
    private PlayerUtils() {
    }

    @Nullable
    public static EntityPlayer getRandomPlayer(@Nonnull World world) {
        List players = world.func_175661_b(EntityPlayer.class, Predicates.alwaysTrue());
        if (players.size() == 1) {
            return (EntityPlayer)players.get(0);
        }
        if (players.size() > 0) {
            return (EntityPlayer)players.get(XorShiftRandom.current().nextInt(players.size()));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isHolding(@Nonnull EntityPlayer player2, @Nonnull Item item, @Nonnull EnumHand hand) {
        ItemStack stack = player2.func_184586_b(hand);
        return ItemStackUtil.isValidItemStack(stack) && stack.func_77973_b() == item;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isHolding(@Nonnull EntityPlayer player2, @Nonnull Item item) {
        return PlayerUtils.isHolding(player2, item, EnumHand.MAIN_HAND) || PlayerUtils.isHolding(player2, item, EnumHand.OFF_HAND);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public static Entity entityImLookingAt(@Nonnull EntityPlayer player2) {
        RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
        if (result != null && result.field_72313_a == RayTraceResult.Type.ENTITY) {
            return result.field_72308_g;
        }
        return null;
    }
}

