/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.blockartistry.lib.BlockStateProvider;
import org.blockartistry.lib.SideLocal;

@SideOnly(value=Side.CLIENT)
public final class WorldUtils {
    private static final SideLocal<BlockStateProvider> blockProvider = new SideLocal<BlockStateProvider>(){

        @Override
        protected BlockStateProvider initialValue(@Nonnull Side side) {
            return new BlockStateProvider();
        }
    };
    private static final BlockStateProvider provider = new BlockStateProvider();

    private WorldUtils() {
    }

    @Nonnull
    public static BlockStateProvider getDefaultBlockStateProvider() {
        return provider;
    }

    @Nullable
    public static Entity locateEntity(@Nonnull World world, int entityId) {
        Entity entity = null;
        if (world != null) {
            try {
                entity = world.func_73045_a(entityId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return entity;
    }

    public static boolean isSolidBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.getBlockState(world, pos).func_185904_a().func_76220_a();
    }

    public static boolean isSolidBlock(@Nonnull World world, int x, int y, int z) {
        return WorldUtils.getBlockState(world, x, y, z).func_185904_a().func_76220_a();
    }

    public static boolean isAirBlock(@Nonnull IBlockState state) {
        return state.func_177230_c() == Blocks.field_150350_a;
    }

    public static boolean isLeaves(@Nonnull IBlockState state) {
        return state.func_185904_a() == Material.field_151584_j;
    }

    public static boolean isAirBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.isAirBlock(WorldUtils.getBlockState(world, pos));
    }

    public static boolean isAirBlock(@Nonnull World world, int x, int y, int z) {
        return WorldUtils.isAirBlock(WorldUtils.getBlockState(world, x, y, z));
    }

    @Nonnull
    public static IBlockState getBlockState(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.getDefaultBlockStateProvider().setWorld(world).getBlockState(pos);
    }

    @Nonnull
    public static IBlockState getBlockState(@Nonnull World world, int x, int y, int z) {
        return WorldUtils.getDefaultBlockStateProvider().setWorld(world).getBlockState(x, y, z);
    }

    public static boolean isFullWaterBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.isFullWaterBlock(WorldUtils.getDefaultBlockStateProvider().setWorld(world).getBlockState(pos));
    }

    public static boolean isFullWaterBlock(@Nonnull IBlockState state) {
        return state.func_185904_a() == Material.field_151586_h && state.func_177230_c().func_176223_P() == state;
    }

    public static boolean isChunkAvailable(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.getDefaultBlockStateProvider().setWorld(world).isAvailable(pos);
    }

    public static BlockPos getTopSolidOrLiquidBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.getDefaultBlockStateProvider().setWorld(world).getTopSolidOrLiquidBlock(pos);
    }

    public static boolean hasVoidPartiles(@Nonnull World world) {
        return world.func_175624_G() != WorldType.field_77138_c && !world.field_73011_w.field_76576_e;
    }

    public static Biome getBiome(@Nonnull World world, @Nonnull BlockPos pos) {
        return WorldUtils.getDefaultBlockStateProvider().setWorld(world).getBiome(pos);
    }
}

